\name{SoloWPCCurve}
\alias{SoloWPCCurve}

\title{Generate Single Weighted Predictiveness Curve in Graph}

\description{
This function will generate one single weighted predictiveness curve in graph using the estimates provided by "npr.wpc.est" function.
It helps to visualize the relationship between survival rate and biomarker.}

\usage{
SoloWPCCurve(wpc, xlab, ylab, main, ylim , xlim, type, col, lwd, legendloc, 
legendtxt, confi, ptsest)
}

\arguments{
  \item{wpc}{It is the object generated by function cox.wpc.est or npr.wpc.est.}
  \item{xlab}{It is the title for x axis; default is "Marker".}
  \item{ylab}{It is the title for y axis; default is "Survival Rate".}
  \item{main}{It is the title for the plot; default is "Weighted Predictiveness Curve".}
  \item{ylim}{It creates the continuous scale of y axis of the plot; default is "c(0,1)".}
  \item{xlim}{It creates the continuous scale of y axis of the plot; default is "c(0,100)".}
  \item{type}{It defines the type of the curve; default is "l".}
  \item{col}{It defines the color of the curve; default is "red".}
  \item{lwd}{It defines the width of the curve; default is "2".}
  \item{legendloc}{It specifies the location of the legend; default is "bottomright".}
  \item{legendtxt}{It provides the text of the legend; defalut is "c("Method1")".}
  \item{confi}{It provides the option of drawing the confidence bands; default is "N", which means no confidence band is needed; "Y" will report the confidence band.}
  \item{ptsest}{It provides the option of drawing the point estimates; default is "N", which means no point estimates is needed; "Y" will report the point estimates.}
}


\references{Yang H., Tang R., Hale M. and Huang J. (2016) A visualization method measuring the performance of biomarkers for guiding treatment decisions \emph{Pharmaceutical Statistics}, 15(\bold{2}), 1539-1612
}

\author{
Hui Yang \email{huiy@amgen.com}, Rui Tang \email{rui_tang@vrtx.com} and Jing Huang \email{jinghuang0@gmail.com}
}

\seealso{
\code{\link{DuoWPCCurve}}, \code{\link{TrioWPCCurve}}
}

\examples{
	# Get the estimate of predictiveness curve from npr.wpc.est functions 
	# and print the corresponding predictiveness curve

	npr.object = npr.wpc.est(event=wpcdata$OSday, censor=wpcdata$OScensor, 
	marker=wpcdata$Biomarker1,cutoff=180,method="number.subjt",weights="normal",
	nsub=10,sspeed=1,df=2,confi="NO")

	SoloWPCCurve(npr.object,xlab="Marker",ylab="Survival Rate",
	main="Weighted Predictiveness Curve",ylim=c(0,1),xlim=c(0,100),
	type="l",col="red",lwd=2,confi="N",ptsest="Y")
	
	# Get the estimate of predictiveness curve from cox.wpc.est functions 
	# and print the corresponding predictiveness curve 

	cox.object = cox.wpc.est(event=wpcdata$OSday, censor=wpcdata$OScensor, 
	marker=wpcdata$Biomarker1,cutoff=180,quantile=0.95)
	
	SoloWPCCurve(cox.object,xlab="Marker",ylab="Survival Rate",
	main="Weighted Predictiveness Curve",ylim=c(0,1),xlim=c(0,100),
	type="l",col="red",lwd=2,confi="N",ptsest="Y")

}

\keyword{WPC Graph}