\name{DuoWPCCurve}
\alias{DuoWPCCurve}

\title{Generate Two Weighted Predictiveness Curves in Graph
}
\description{
This function will generate two weighted predictiveness curves using the estimates provided by "npr.wpc.est" or "cox.wpc.est" functions.
It can be used to compare the relationships between survival rate and biomarker from two different curves. 

We can utilize this function to compare the performance between non-parametric predictiveness curve and parametric(cox) predictiveness curve, or compare the performance from non-parametric predictiveness curves using two different sets of parameters,
or compare the predictiveness curves by using data from two different treatment groups and therefore compare treatment-by-biomarker relationships. 
}
\usage{
DuoWPCCurve(wpc1, wpc2, xlab, ylab, main, ylim, xlim, type, col1, col2, lwd, 
legendloc, legendtxt, confi, ptsest)
}

\arguments{
  \item{wpc1}{It is the object1 generated by function cox.wpc.est or npr.wpc.est.}
  \item{wpc2}{It is the object2 generated by function cox.wpc.est or npr.wpc.est.}
  \item{xlab}{It is the title for x axis; default is "Marker".}
  \item{ylab}{It is the title for y axis; default is "Survival Rate".}
  \item{main}{It is the title for the plot; default is "Weighted Predictiveness Curve".}
  \item{ylim}{It creates the continuous scale of y axis of the plot; default is "c(0,1)".}
  \item{xlim}{It creates the continuous scale of y axis of the plot; default is "c(0,100)".}
  \item{type}{It defines the type of the curves; default is "l".}
  \item{col1}{It defines the color of the curve 1 from object 1; default is "red".}
  \item{col2}{It defines the color of the curve 2 from object 2; default is "blue".}
  \item{lwd}{It defines the width of the curve; default is "2".}
  \item{legendloc}{It specifies the location of the legend; default is "bottomright".}
  \item{legendtxt}{It provides the text of the legend; default is "c("Method1")".}
  \item{confi}{It provides the option of drawing the confidence bands; default is "N", which means no confidence band is needed; "Y" will report the confidence band.}
  \item{ptsest}{It provides the option of drawing the point estimates; default is "N", which means no point estimates is needed; "Y" will report the point estimates.}
}


\references{ Yang H., Tang R., Hale M. and Huang J. (2016) A visualization method measuring the performance of biomarkers for guiding treatment decisions \emph{Pharmaceutical Statistics}, 15(\bold{2}), 1539-1612
}

\author{
Hui Yang \email{huiy@amgen.com}, Rui Tang \email{rui_tang@vrtx.com} and Jing Huang \email{jinghuang0@gmail.com}
}

\seealso{
\code{\link{SoloWPCCurve}}, \code{\link{TrioWPCCurve}}
}

\examples{
	# Get the estiamte of predictiveness curve from npr.wpc.est functions 
	
	npr.object = npr.wpc.est(event=wpcdata$OSday, censor=wpcdata$OScensor, 
	marker=wpcdata$Biomarker1,cutoff=180,method="number.subjt",weights="normal",
	nsub=10,sspeed=1,df=2,confi="NO")
	
	# Get the estiamte of predictiveness curve from cox.wpc.est functions 

	cox.object = cox.wpc.est(event=wpcdata$OSday, censor=wpcdata$OScensor, 
	marker=wpcdata$Biomarker1,cutoff=180,quantile=0.95)

	# Print Predictiveness Curve

	DuoWPCCurve(npr.object,cox.object,xlab="Marker",ylab="Survival Rate",
	main="Weighted Predictiveness Curve",ylim=c(0,1),xlim=c(0,100),type="l",
	col1="red",col2="blue",lwd=2,legendloc="bottomright",
	legendtxt=c("treatment","placebo"),confi="N", ptsest="N")}

\keyword{WPC Graph}
