% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_admin_data.R
\name{download_admin_data}
\alias{download_admin_data}
\title{Download administrative boundaries from geoBoundaries API}
\usage{
download_admin_data(
  iso3,
  release,
  path_output,
  simplified = FALSE,
  keep_geojson = FALSE
)
}
\arguments{
\item{iso3}{A three-letter capitalized character string. Must follow the ISO-3166 Alpha-3 country code}

\item{release}{A character string specifying the release type on the geoBoundaries API. It should be one of 'gbOpen',
'gbHumanitarian', or 'gbAuthoritative'.  Release types are described at \url{https://www.geoboundaries.org/api.html#api}.}

\item{path_output}{A character string giving the file path of an output directory to save downloaded data.}

\item{simplified}{Logical indicating whether to download simplified administrative boundaries instead of high resolution. Default is FALSE.}

\item{keep_geojson}{Logical indicating whether to keep the raw geojson files downloaded from geoBoundaries API. Default is FALSE.}
}
\value{
Character string giving path to downloaded data.
}
\description{
This function takes a single ISO country code and downloads the corresponding
high resolution administrative boundary \href{https://en.wikipedia.org/wiki/GeoJSON}{GeoJSON} files from the \href{https://www.geoboundaries.org/}{www.geoBoundaries.org} API
hosted at GitHub \href{https://github.com/wmgeolab/geoBoundaries/tree/9469f09592ced973a3448cf66b6100b741b64c0d}{HERE}. If the
desired administrative level is not available the next most detailed administrative level is returned.
}
\examples{
\donttest{

download_admin_data(iso3 = 'MCO',
                    release = 'gbOpen',
                    path_output = tempdir())
}

}
