% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_delta_delta_ct.R
\name{apply_delta_delta_ct}
\alias{apply_delta_delta_ct}
\title{Apply the delta delta Ct calculation to a data.frame}
\usage{
apply_delta_delta_ct(
  df,
  target_names,
  reference_names,
  pae_names = NULL,
  pae_values = NULL
)
}
\arguments{
\item{df}{A data.frame containing the following columns: 'location_id', 'sample_date', 'target_name', and 'ct_value'.}

\item{target_names}{Character vector giving the names of the target genes.}

\item{reference_names}{Character vector giving the names of the reference genes associated with each target gene.}

\item{pae_names}{Character vector giving the names of the target genes and reference genes for which the percentile amplification efficiency has been estimated. Default is NULL.}

\item{pae_values}{A numeric scalar giving the estimated PCR amplification efficiency for each of the names in \code{pae_names}. Defaults is NULL, which assumes 100\% efficiency.}
}
\value{
data.frame
}
\description{
This function will calculate the delta delta Ct metric for all applicable observations in a data.frame
by applying the \code{calc_delta_delta_ct} function. The data.frame must have the following columns:
'location_id', 'sample_date', 'target_name', and 'ct_value'. The relevant target_names and associated reference_names
must be provided. The result is a data.frame containing a 'delta_delta_ct' column which can be merge into the source data.frame.
}
\examples{

pae <- apply_amplification_efficiency(template_WES_standard_curve)

ddct_standard <- apply_delta_delta_ct(df = template_WES_data,
                                      target_names = c('target_1', 'target_2', 'target_3'),
                                      reference_names = rep('target_0', 3))

ddct_adjusted <- apply_delta_delta_ct(df = template_WES_data,
                                      target_names = c('target_1', 'target_2', 'target_3'),
                                      reference_names = rep('target_0', 3),
                                      pae_names = pae$target_name,
                                      pae_values = pae$mean)

head(ddct_adjusted)

}
