% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{new_visitation_forecast}
\alias{new_visitation_forecast}
\title{visitation_forecast Class}
\usage{
new_visitation_forecast(
  forecasts,
  n_ahead,
  proxy_forecasts,
  onsite_usage_forecasts,
  beta,
  constant,
  criterion,
  past_observations,
  lag_estimate
)
}
\arguments{
\item{forecasts}{A time series of forecasts for the visitation model.}

\item{n_ahead}{An integer describing the number of forecasts made.}

\item{proxy_forecasts}{A time series of forecasts of the popularity proxy series.}

\item{onsite_usage_forecasts}{A time series of forecasts of the original time series.}

\item{beta}{A numeric or a character string specifying the seasonality adjustment factor. The default option is "estimate", in which case, it is estimated by using the Fisher's z-transformed lag-12 autocorrelation. Even if an actual value is supplied, if ref_series is supplied, it is overwritten by the least squares estimate.}

\item{constant}{A numeric specifying the constant term in the model. This constant is understood as the mean of the trend-adjusted time_series. The default option is 0, implying that the time_series well represents the actual visitation counts, which is rarely the case. If ref_series is supplied, the constant is overwritten by the least squares estimate.}

\item{criterion}{One of "MSE" or "Nonparametric", to specify the criterion used to select the lag.}

\item{past_observations}{One of "none", "fitted", or "ref_series". If "fitted", past model fitted values are used. If "ref_series", the reference series in the visitation model object is used. Note that if difference = TRUE, one of these is needed to forecast the first difference.}

\item{lag_estimate}{A numeric value specifying the estimated lag in the visitation model.}
}
\value{
Object of class "Visitation_forecast".
}
\description{
Class for visitation_model predictions (for use with predict.visitation_model()).
}
