% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otherfunc.R
\name{VWRfirstrun}
\alias{VWRfirstrun}
\title{VertexWiseR system requirements installation}
\usage{
VWRfirstrun(requirement = "any", n_vert = 0)
}
\arguments{
\item{requirement}{String that specifies a requirement to enquire about (for specific 'BrainStat' libraries: 'fsaverage5', 'fsaverage6', 'yeo_parcels'; for neurosynth database: "neurosynth"). Default is 'any' requirement and checks everything.}

\item{n_vert}{Numeric vector indicating the number of vertices of a given surface data so that only the required templates are asked for}
}
\value{
No returned value in interactive session. In non-interactive sessions, a string object informing that system requirements are missing.
}
\description{
Helps the user verify if VertexWisrR's system requirements are present and install them ('Miniconda', 'BrainStat' toolbox and libraries). If they are installed already, nothing will be overwritten.
}
\details{
VertexWiseR imports and makes use of the R package 'reticulate.' 'reticulate' is a package that allows R to borrow or translate Python functions into R. Using 'reticulate', the package calls functions from the 'BrainStat' Python module. For 'reticulate' to work properly with VertexWiseR, the latest version of 'Miniconda' needs to be installed with it — 'Miniconda' is a lightweight version of Python, specifically for use within 'RStudio'. Likewise, analyses of cortical surface require fsaverage templates as imported by 'BrainStat' The decode_surf_data() function also requires the 'Neurosynth' database to be downloaded.
}
\examples{
VWRfirstrun()
}
