% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VUScov.R
\name{VUScov}
\alias{VUScov}
\title{Covariance of two volumes under the ROC surface}
\usage{
VUScov(y, fx1, fx2, ncores = 1, clusterType = "SOCK")
}
\arguments{
\item{y}{a vector of realized categories.}

\item{fx1}{a vector of predicted values of the ranking function f1.}

\item{fx2}{a vector of predicted values of the ranking function f2.}

\item{ncores}{number of cores to be used for parallelized computations. Its default value is 1.}

\item{clusterType}{type of cluster to be initialized in case more than one core is used for calculations. Its default value is "SOCK". For details regarding the different types to be used, see \code{\link[parallel]{makeCluster}}.}
}
\value{
The implemented algorithm is based on Waegeman, De Baets and Boullart (2008). A list of length three is returned, containing the following components:
\item{cov}{covariance of the two volumes under the ROC surface implied by f1 and f2}
\item{val_f1}{volume under the ROC surface implied by f1}
\item{val_f2}{volume under the ROC surface implied by f2}
}
\description{
Computes the covariance of the two volumes under the ROC surface (VUS) implied by two predictions \code{fx1} and \code{fx2} (i.e. values of two ranking functions f1 and f2) for a vector of realisations \code{y} (i.e. realised categories) in a multi-class classification problem.
}
\examples{
VUScov(c(1,2,1,3,2,3),c(1,2,3,4,5,6),c(1,3,2,4,6,5))
}
\references{
Waegeman W., De Baets B., Boullart L., 2008. On the scalability of ordered multi-class ROC analysis. Computational Statistics & Data Analysis 52, 3371-3388.
}
