% Generated by roxygen2 (4.0.0): do not edit by hand
\name{plot.VSURF}
\alias{plot.VSURF}
\alias{plot.VSURF.interp}
\alias{plot.VSURF.pred}
\alias{plot.VSURF.thres}
\title{Plot of VSURF results}
\usage{
\method{plot}{VSURF}(x, nvar.imp = NULL, nvar.sd = NULL,
  var.names = FALSE, ...)

\method{plot}{VSURF.thres}(x, nvar.imp = NULL, nvar.sd = NULL, imp = TRUE,
  imp.sd = TRUE, var.names = FALSE, ...)

\method{plot}{VSURF.interp}(x, var.names = FALSE, ...)

\method{plot}{VSURF.pred}(x, var.names = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{VSURF}, \code{VSURF.thres},
\code{VSURF.interp} or \code{VSURF.pred}, which is the result of the
\code{\link{VSURF}} function (or resp. \code{\link{VSURF.thres}},
\code{\link{VSURF.interp}} or \code{\link{VSURF.pred}}).}

\item{nvar.imp}{The number of variables to be kept for the VI mean plot (top
left graph).}

\item{nvar.sd}{The number of variables to be kept for the VI standard
deviation plot (top left graph).}

\item{imp}{If TRUE (default) VI mean is plotted, if FALSE not.}

\item{imp.sd}{If TRUE (default) VI standard deviation is plotted, if FALSE
not.}

\item{var.names}{If FALSE (default) xticks are the numbering given by the
sorting of VI mean, if TRUE they are the variables names.}

\item{\dots}{Arguments to be passed to \code{\link{par}} (they will affect
all plots)}
}
\description{
This function plots 4 graphs illustrating VSURF results.
}
\details{
The 2 graphs of the top row correspond to the "thresholding step" (and only
these 2 graphs are plotted by the \code{plot.VSURF.thres} function).  The
top left graph plots the mean variable importance in decreasing order (black
curve). The red horizontal line represent the value of the threshold.  The
top right graph plots the standard deviation of variable importance with
variables ordered according to their mean variable importance in decreasing
order (black curve). The green line represents the predictions given by a
CART tree fitted to the black curve (the standard deviations). Finally, the
dotted horizontal red line represents the minimum value of the CART
predictions, which actually is the value of the threshold.

The bottom left graph corresponds to the "interpretation step" (and only
this graph is plotted by the \code{plot.VSURF.interp} function). It plots
the mean OOB error rate of embedded random forests models (from the one with
only one variable as predictor, to the one with all variables kept after the
"thresholding step"). The vertical red line indicates the retained model.

The bottom right graph corresponds to the "predicton step" (and only this
graph is plotted by the \code{plot.VSURF.pred} function). It plots the mean
OOB error rate of embedded random forests models (the difference, here,
being that variables are added to the model in a step-wise manner). The
retained model is the final one.
}
\examples{
\dontrun{
data(iris)
iris.vsurf <- VSURF(x=iris[,1:4], y=iris[,5])
plot(iris.vsurf)
plot(iris.vsurf, var.names=TRUE)

# A more interesting example with toys data (see \\code{\\link{toys}})
# (a few minutes to execute) and intermediate functions
data(toys)
toys.vsurf <- VSURF(x=toys$x, y=toys$y)
plot(toys.vsurf)
plot(toys.vsurf, nvar.imp=50, nvar.sd=50)
toys.thres <- VSURF.thres(x=toys$x, y=toys$y)
plot(toys.thres)
par(mfrow=c(1,1))
plot(toys.thres, nvar.imp=70, imp.sd=FALSE)
toys.interp <- VSURF.interp(x=toys$x, y=toys$y, vars=toys.thres$varselect.thres)
plot(toys.interp, var.names=TRUE)
toys.pred <- VSURF.pred(x=toys$x, y=toys$y, err.interp=toys.interp$err.interp,
                        varselect.interp=toys.interp$varselect.interp)
plot(toys.pred, var.names=TRUE)
}
}
\author{
Robin Genuer, Jean-Michel Poggi and Christine Tuleau-Malot
}
\references{
Genuer, R. and Poggi, J.M. and Tuleau-Malot, C. (2010),
\emph{Variable selection using random forests}, Pattern Recognition Letters
31(14), 2225-2236
}
\seealso{
\code{\link{VSURF}}, \code{\link{summary.VSURF}}
}

