% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vca.R
\name{getSSQqf}
\alias{getSSQqf}
\title{ANOVA Sum of Squares via Quadratic Forms}
\usage{
getSSQqf(Data, tobj, random = NULL)
}
\arguments{
\item{Data}{(data.frame) with the data}

\item{tobj}{(terms) object derived from original formula object}

\item{random}{(character) vector, optionally containing information about each
model term, whether it is random or fixed (only used in mixed models)}
}
\value{
(list) representing the  with variables:\cr
			\item{aov.tab}{basic ANOVA-table with degrees of freedom (DF), SS and MS}
			\item{Lmat}{(list) with components 'Z' and 'A'}
}
\description{
Compute ANOVA Type-1 sum of squares for linear models.
}
\details{
This function performs estimation of ANOVA Type-1 sum of squares
using an approach of expressing them as quadratic forms in \code{y},
the column vector of observations. This is an utility function not
intended to be called directly.
For each term in the formula the design-matrix \code{Z} and the corresponding
\code{A}-matrix 
Degrees of freedom for each term are determined calling function \code{\link{anovaDF}}.
}
\examples{
\dontrun{
data(dataEP05A2_1)
res <- VCA:::getSSQqf(dataEP05A2_1, terms(y~day/run))
str(res)
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com},
			Florian Dufey \email{florian.dufey@contractors.roche.com}
}
