% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.VCA}
\alias{plot.VCA}
\title{Standard 'plot' Method for 'VCA' S3-Objects.}
\usage{
\method{plot}{VCA}(x, ...)
}
\arguments{
\item{x}{(VCA) object}

\item{...}{additional arguments to be passed to or from methods.}
}
\value{
nothing, instead a plot is generated
}
\description{
Create a variability chart from a 'VCA'-object, i.e. from a fitted model.
}
\details{
This function extracts the data and the model-formula from a fitted 'VCA'-object and calls function \code{\link{varPlot}}
accepting all its arguments. Please see the documention of function \code{\link{varPlot}} for a detailed description.

It will not be differentiated between fixed and random effects when calling this function on a fitted linear mixed model.
}
\examples{
\dontrun{
data(dataEP05A2_1)
fit <- anovaVCA(y~day/run, dataEP05A2_1)

# standard plot without any extras
plot(fit)

# plot with some additional features
plot(fit, MeanLine=list(var=c("int", "day"), col=c("cyan", "blue"), lwd=c(2,2)))

# more complex model
data(realData)
Data <- realData[realData$PID == 1,]
fit2 <- anovaVCA(y~(calibration+lot)/day/run, Data)
plot(fit2, 
		BG=list(var="calibration",
				col=c("#f7fcfd","#e5f5f9","#ccece6","#99d8c9",
				      "#66c2a4","#41ae76","#238b45","#006d2c","#00441b"),
				col.table=TRUE),
	VLine=list(var=c("calibration", "lot"),
				   col=c("black", "darkgray"), lwd=c(2,1), col.table=TRUE),
		JoinLevels=list(var="lot", col=c("#ffffb2","orangered","#feb24c"),
				        lwd=c(2,2,2)),
		MeanLine=list(var="lot", col="blue", lwd=2))
#' }
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
\seealso{
\code{\link{varPlot}}, \code{\link{anovaVCA}},\code{\link{remlVCA}}, \code{\link{anovaMM}},\code{\link{remlMM}}
}

