% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_roc3.R
\name{simple_roc3}
\alias{simple_roc3}
\title{Primitive non-parametric function for calculating false and true positive
rate for two comparable samples with ordinal data.}
\usage{
simple_roc3(norm, abnorm)
}
\arguments{
\item{norm}{Ordinal data of the norm group (controls).}

\item{abnorm}{Ordinal data of the abnorm group (patients).}
}
\value{
List of \itemize{
\item $testscores sorted available unique test scores.
\item $dich.thresholds Indicates the thresholds and
their interpretation. If \code{mean(norm) > mean(abnorm)}, the thresholds
are <= test score, otherwise the thresholds are >= test score.
\item $d0
Frequencies of ordinal scores of norm group, from lowest to highest score
\item $d1 Frequencies of ordinal scores of abnorm group, from lowest to
highest score
\item $TP Cumulative true positive scores. If
\code{mean(norm) > mean(abnorm)} the highest score is the total sum,
otherwise the lowest score is the total sum.
\item $FP Cumulative false
positive scores. If \code{mean(norm) > mean(abnorm)} the highest score is
the total sum, otherwise the lowest score is the total sum.
\item $tpr True
positive rates (Sensitivities) for each threshold
\item $fpr False positive
rates (1 - Specificities) for each threshold }
}
\description{
Primitive non-parametric function for calculating false and true positive
rate for two comparable samples with ordinal data.
}
\details{
This function does not check anything. Argument \code{norm} and
\code{abnorm} must have the correct ordinal data. The thresholds only
concern available test scores and are always ordered from lowest to
highest.
}
\examples{
norm = round(rnorm(100, 3, 1))
abnorm= round(rnorm(80, 5, 2))
(res=simple_roc3(norm, abnorm))
# Plot ROC curve
plot(x=res$fpr, y=res$tpr, type='l')
abline(a=c(0,0), b=c(1,1))
}
