% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/us_congressional.R
\name{us_congressional}
\alias{us_congressional}
\title{Congressional district boundaries (contemporary)}
\usage{
us_congressional(resolution = c("low", "high"), states = NULL)
}
\arguments{
\item{resolution}{The resolution of the boundaries.}

\item{states}{A character vector of state or territory names. Only boundaries
inside these states/territories will be returned. If \code{NULL}, all
boundaries will be returned.}
}
\value{
A SpatialPolygonsDataFrame.
}
\description{
Get the current (2014) boundaries for U.S. Congressional districts.
}
\examples{
va_congressional <- us_congressional(states = "Virginia")
if (require(sp)) {
   plot(va_congressional)
}

}
\seealso{
For documentation of and citation to the underlying shapefiles for
  contemporary data from the U.S. Census Bureau, see
  \code{\link{census_boundaries}}.
}

