% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UMR_CC_generic.R
\name{UMR_curv_generic}
\alias{UMR_curv_generic}
\alias{UMR_curv_generic2}
\alias{UMR_CC_generic}
\title{@title Second derivative computations of least-squares Unlinked  Isotonic Regression criterion ("SIR"  comes from "shuffled isotonic regression" although this terminology is now outdated).}
\usage{
UMR_curv_generic(
  yy,
  mm,
  ww_y = rep(1/length(yy), length(yy)),
  ww_m = rep(1/length(mm), length(mm)),
  densfunc,
  BBpfunc
)

UMR_curv_generic2(
  yy,
  mm,
  ww_y = rep(1/length(yy), length(yy)),
  ww_m = rep(1/length(mm), length(mm)),
  densfunc,
  DDfunc
)

UMR_CC_generic(
  yy,
  mm,
  ww_y = rep(1/length(yy), length(yy)),
  ww_m = rep(1/length(mm), length(mm)),
  densfunc,
  DDfunc
)
}
\arguments{
\item{yy}{Y (response) observation vector (numeric)}

\item{mm}{Current (unsorted) estimate/iterate at which to compute
gradient. (Length is <= than the number of X observations in the problem).}

\item{ww_y}{Weights (nonnegative, sum to 1) corresponding to yy.  Same length as yy.
Default is just 1/length(yy) for each value.}

\item{ww_m}{Weights (nonnegative, sum to 1) corresponding to mm.  Same length as mm.}

\item{densfunc}{This is the error density, a  function object (Balabdaoui, Doss, Durot (2021+).}

\item{BBpfunc}{This is the function B', i.e. derivative of "B" function in the paper. 

    @details The  "CC" or  "curv" functions  are used to  be passed  in to
    UMRactiveSet_trust() (generally  after 'currying'/substituting  in for
    the  parameter  arguments).   UMR_CC_generic  returns  a  1xlength(mm)
    matrix giving the  C function defined in  the paper.  UMR_curv_generic
    is    returning    also    a   1xlength(mm)    matrix    giving    the
    (d^2/dtheta^2)(objective function), where "theta" is as defined in the
    paper.   [This  is  mathfrak{C}  in the  paper.]   These  are  similar
    quantities, the "curv" quantity is just C rescaled by the weight.  See
    calculations  in  paper.   The  more substantive  difference  is  that
    UMR_CC_generic requires  a closed  form for  the "D"  function whereas
    UMR_curv_generic simply  uses the hessian computation  (i.e., requires
    B', the derivative of the "B"  function).  (The closed form of the "D"
    function can be found  from the closed form of the  hessian, but it is
    not necessary.)

     UMR_curv_generic2  is analogous  to UMR_curv_generic  but the  latter
     relies on UMR_CC_generic.

     UMR_CC_generic1 is  analogous to UMR_CC_generic  (aka CC_SIR_generic)
     but the former is calculated  in fashion identical to UMR_curv_generic
     (i.e., relying on UMRhess).

     DDfunc_Gauss_generic is the "D" function that can be passed in (after
     substituting  for  sig) for  DDfunc  in  various other  functions  to
     compute the "C" function (e.g., UMR_CC_generic).
    
     Note: "CC" and "DD", etc., refer to the "C" or "D" functions.  Double
     lettering is  a convention  often used  in the code  to refer  to the
     single letter.}

\item{DDfunc}{This is the function "D" defined in the second derivative 
calculations in the paper (Balabdaoui, Doss, Durot (2021+).}
}
\description{
@title Second derivative computations of least-squares Unlinked  Isotonic Regression criterion ("SIR"  comes from "shuffled isotonic regression" although this terminology is now outdated).
}
