% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_gene_drug_response.R
\name{analyze_gene_drug_response_asso}
\alias{analyze_gene_drug_response_asso}
\title{Analyze Association between Gene (Signature) and Drug Response with CCLE Data}
\usage{
analyze_gene_drug_response_asso(gene_list, combine = FALSE)
}
\arguments{
\item{gene_list}{a gene symbol list.}

\item{combine}{if \code{TRUE}, combine the expression of gene list as
a gene signature.}
}
\value{
a \code{data.frame}
\itemize{
\item If \code{combine} is \code{TRUE}, genes are combined as \code{signature}.
\item \code{mean.diff} and \code{median.diff} indicate mean and median of
normalized expression difference between High IC50 cells and Low IC50 cells.
The cutoff between High and Low are median IC50.
}
}
\description{
Analyze partial correlation of gene-drug association after
controlling for tissue average expression.
}
\examples{
\dontrun{
analyze_gene_drug_response_asso("TP53")
analyze_gene_drug_response_asso(c("TP53", "KRAS"))
analyze_gene_drug_response_asso(c("TP53", "KRAS"), combine = TRUE)

# Visualization
vis_gene_drug_response_asso("TP53")
}
}
