% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.twowayfeweights}
\alias{print.twowayfeweights}
\title{A print method for twowayfeweights objects}
\usage{
\method{print}{twowayfeweights}(x, ...)
}
\arguments{
\item{x}{A twowayfeweights object.}

\item{...}{Currently ignored.}
}
\description{
Printed display of twowayfeweights objects.
}
\examples{
# The following example is based on data from F. Vella and M. Verbeek (1998), 
# "Whose Wages Do Unions Raise? A Dynamic Model of Unionism and Wage Rate 
# Determination for Young Men". 
# Results and further details about the estimation below can be found in 
# Section V.C of de Chaisemartin & D'Haultfoeuille (2020a).
# Run the following lines to download the dataset in your local working 
# directory and load it to your R environment:

repo = "chaisemartinPackages/twowayfeweights/main"
file = "wagepan_twfeweights.dta"
url = paste("https://raw.githubusercontent.com", repo, file, sep = "/")
wagepan =  haven::read_dta(url)

# Now let's load this package and run some estimations.
library(TwoWayFEWeights)

# The default `type = "feTR"` estimation strategy uses a fixed-effects
# strategy under the assumption that parallel trends holds. 
twowayfeweights(
  wagepan,                        # input data
  "lwage", "nr", "year", "union", # Y, G, T, & D
  type                = "feTR",   # estimation type ("feTR" is the default)
  summary_measures    = TRUE,     # show summary measures (optional)
  test_random_weights = "educ"    # check randonmess of weights (optional)
)

# The next line performs the same exercise using first differences of outcome
# and treatment:
twowayfeweights(
  wagepan,
  "diff_lwage", "nr", "year", "diff_union", # Y & D changed to differenced versions
  type                = "fdTR",             # changed
  D0                  = "union",            # added (D0 is req'd for type="fdTR")
  summary_measures    = TRUE,
  test_random_weights = "educ"
)

# Please note that the number of negative weights could be different from Section 
# V.C. of de Chaisemartin and D'Haultfoeuille (2020a) due to rounding errors that 
# affected older versions of the commands.

}
