% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_tweets}
\alias{plot_tweets}
\title{Plot tweets on a static map}
\usage{
plot_tweets(data, region = ".", alpha = 0.01, ...)
}
\arguments{
\item{data}{A data frame of tweets parsed by \link[Twitmo]{load_tweets} or returned by \link[Twitmo]{pool_tweets}.}

\item{region}{Character vector specifying region. Returns a world \link[maps]{map} by default.
For higher resolutions specify a region.}

\item{alpha}{A double between 0 and 1 specifying the opacity of plotted points.
See \link[maps]{iso3166} for country codes.}

\item{...}{Extra arguments passed to \link[graphics]{polygon} or \link[graphics]{lines}.}
}
\value{
Maps where each dot represents a tweet.
}
\description{
Plot tweets on a static map with base plot.
}
\details{
This function can be used to generate high resolution spatial plots of tweets.
Works with data frames of tweets returned by \link[Twitmo]{pool_tweets} as well as data frames
read in by \link[Twitmo]{load_tweets} and then augmented by lat/lng coordinates with \link[rtweet]{lat_lng}.
For larger view resize the plot window then call \code{plot_tweets} again.
}
\examples{

\dontrun{

library(Twitmo)

# Plot tweets on mainland USA
mytweets <- load_tweets(system.file("extdata", "tweets_20191027-141233.json", package = "Twitmo"))

plot_tweets(mytweets, region = "USA(?!:Alaska|:Hawaii)", alpha=1)
# Add title
title("My tweets on a map")
}

}
\seealso{
\link[maps]{map}, \link[maps]{iso3166}
}
