% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prod_mod.R
\name{prod_mod}
\alias{prod_mod}
\title{Production models}
\usage{
prod_mod(data, plot = FALSE)
}
\arguments{
\item{data}{a dataframe consisting of:
\itemize{
  \item \code{year} year vector,
  \item \code{Y} catch in weight per year, and
  \item \code{f} fishing effort per year, or
  \item \code{CPUE} catch per unit of effort per year (optional).
}}

\item{plot}{logical; if TRUE, a graph is displayed}
}
\value{
A list with the input parameters and following list objects:
\itemize{
  \item \strong{Schaefer_lm}: intercept and slope of linear model following
  the Schaefer model,
  \item \strong{Fox_lm}: intercept and slope of linear model following
  the Fox model,
  \item \strong{Schaefer_MSY}: MSY according to Schaefer model,
  \item \strong{Schaefer_fMSY}: fishing effort yielding in MSY according to
  Schaefer model,
  \item \strong{Schaefer_Bv}: virgin biomass according to Schaefer model,
  \item \strong{ln_CPUE}: natural logarithm of CPUE values,
  \item \strong{Fox_MSY}: MSY according to Fox model,
  \item \strong{Fox_fMSY}: fishing effort yielding in MSY according to Fox model,
  \item \strong{Fox_Bv}: virgin biomass according to Fox model.
}
}
\description{
Production models are holistic models, which
   can be used to estimate maximum sustainable yield (MSY) and virgin biomass. This
   function uses the equilibrium approach to estimate parameters (Schaefer model and
   Fox model).
}
\details{
Production models are also called surplus production models or
   biomass dynamic models. They can be applied if sufficient data are available: effort
   and yield parameters have to be expended over a certain number of years. Furthermore,
   the fishing effort must have undergone substantial changes over the period covered
   (Sparre and Venema, 1998). Either the catch per unit of effort (CPUE) is inserted
   into the model directly (objectname: \code{CPUE}) or the CPUE is calculated from
   the catch and effort, then these two vectors should have required units. There
   are three ways of estimating paramaters of production models, (i) assuming
   equlibrium conditions, (ii) transforming equation to linear form, or (iii)
   time-series fitting (Hilborn and Walters, 1992). The first approach corresponds
   to the Schaefer and Fox model and thus the methodology of this function.
   The authors recommend to use dynamic fitting methods when possible rather than
   the equilibrium approach. For dynamic production models please refer
   to \link{prod_mod_ts}.
}
\examples{
data(trawl_fishery_Java)
prod_mod(data = trawl_fishery_Java, plot = TRUE)

}
\references{
Fox, W. W. Jr., 1970. An exponential surplus-yield model for optimizing exploited fish
populations. \emph{Trans.Am.Fish.Soc.}, 99:80-88

Graham, M., 1935. Modern theory of exploiting a fishery and application to North Sea
trawling. \emph{J.Cons.CIEM}, 10(3):264-274

Hilborn, R., Walters, C. J. (1992). Quantitative fisheries stock assessment:
choice, dynamics and uncertainty. \emph{Reviews in Fish Biology and Fisheries}, 2(2),
177-178.

Schaefer, M., 1954. Some aspects of the dynamics of populations important to the
management of the commercial marine fisheries. \emph{Bull.I-ATTC/Bol. CIAT}, 1(2):27-56

Schaefer, M., 1957. A study of the dynamics of the fishery for yellowfin tuna of the
eastern tropical Pacific Ocean [in English and Spanish]. \emph{Ibid.}, 2(6): 245-285

Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. FAO Fisheries Technical Paper, (306.1, Rev. 2). 407 p.
}
\keyword{MSY}
\keyword{biomass}
\keyword{function}
\keyword{production}
\keyword{surplus}
