% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trial_sequence.R
\name{calculate_weights}
\alias{calculate_weights}
\alias{calculate_weights,trial_sequence_ITT-method}
\alias{calculate_weights,trial_sequence_AT-method}
\alias{calculate_weights,trial_sequence_PP-method}
\title{Calculate Inverse Probability of Censoring Weights}
\usage{
calculate_weights(object, ...)

\S4method{calculate_weights}{trial_sequence_ITT}(object, quiet = FALSE)

\S4method{calculate_weights}{trial_sequence_AT}(object, quiet = FALSE)

\S4method{calculate_weights}{trial_sequence_PP}(object, quiet = FALSE)
}
\arguments{
\item{object}{A \link{trial_sequence} object}

\item{...}{Other arguments used by methods.}

\item{quiet}{Prints model summaries is \code{TRUE}.}
}
\value{
A \link{trial_sequence} object with updated \code{censor_weights} and/or \code{switch_weights} slots
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontshow{
data.table::setDTthreads(2)
}
save_dir <- file.path(tempdir(), "switch_models")
ts <- trial_sequence("PP") |>
  set_data(
    data = data_censored,
    id = "id",
    period = "period",
    treatment = "treatment",
    outcome = "outcome",
    eligible = "eligible"
  ) |>
  set_switch_weight_model(
    numerator = ~ age + x1 + x3,
    denominator = ~age,
    model_fitter = stats_glm_logit(save_path = save_dir)
  ) |>
  calculate_weights()

}
