% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{trial_msm}
\alias{trial_msm}
\title{Fit the marginal structural model for the sequence of emulated trials}
\usage{
trial_msm(
  data,
  outcome_cov = ~1,
  estimand_type = c("ITT", "PP", "As-Treated"),
  model_var = NULL,
  first_followup = NA,
  last_followup = NA,
  analysis_weights = c("asis", "unweighted", "p99", "weight_limits"),
  weight_limits = c(0, Inf),
  include_followup_time = ~followup_time + I(followup_time^2),
  include_trial_period = ~trial_period + I(trial_period^2),
  where_case = NA,
  glm_function = c("glm", "parglm"),
  use_sample_weights = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} containing all the required variables in the person-time format, i.e., the  `long' format.}

\item{outcome_cov}{A RHS formula with baseline covariates to be adjusted for in the marginal structural model for the
emulated trials. Note that if a time-varying covariate is specified in \code{outcome_cov}, only its value at each of the
trial baselines will be included in the expanded data.}

\item{estimand_type}{Specify the estimand for the causal analyses in the sequence of emulated trials. \code{estimand_type = "ITT"} will perform intention-to-treat analyses, where treatment switching after trial baselines are ignored.
\code{estimand_type = "PP"} will perform per-protocol analyses, where individuals' follow-ups are artificially censored
and inverse probability of treatment weighting is applied. \code{estimand_type = "As-Treated"} will fit a standard
marginal structural model for all possible treatment sequences, where individuals' follow-ups are not artificially
censored  but treatment switching after trial baselines are accounted for by applying inverse probability of
treatment weighting.}

\item{model_var}{Treatment variables to be included in the marginal structural model for the emulated trials.
\code{model_var = "assigned_treatment"} will create a variable \code{assigned_treatment} that is the assigned treatment at
the trial baseline, typically used for ITT and per-protocol analyses. \code{model_var = "dose"} will create a variable
\code{dose} that is the cumulative number of  treatments received since the trial baseline, typically used in as-treated
analyses.}

\item{first_followup}{First follow-up time/visit in the trials to be included in the marginal structural model for
the outcome event.}

\item{last_followup}{Last follow-up time/visit in the trials to be included in the marginal structural model for the
outcome event.}

\item{analysis_weights}{Choose which type of weights to be used for fitting the marginal structural model for the
outcome event.
\itemize{
\item \code{"asis"}: use the weights as calculated.
\item \code{"p99"}: use weights truncated at the 1st and 99th percentiles (based on the distribution of weights
in the entire sample).
\item \code{"weight_limits"}: use weights truncated at the values specified in \code{weight_limits}.
\item \code{"unweighted"}: set all analysis weights to 1, even if treatment weights or censoring weights were calculated.
}}

\item{weight_limits}{Lower and upper limits to truncate weights, given as \code{c(lower, upper)}}

\item{include_followup_time}{The model to include the follow up time/visit of the trial (\code{followup_time}) in the
marginal structural model, specified as a RHS formula.}

\item{include_trial_period}{The model to include the trial period (\code{trial_period}) in the marginal structural model,
specified as a RHS formula.}

\item{where_case}{Define conditions using variables specified in \code{where_var} when fitting a marginal structural model
for a subgroup of the individuals. For example, if \code{where_var= "age"}, \code{where_case = "age >= 30"} will only fit the
marginal structural model to the subgroup of individuals. who are 30 years old or above.}

\item{glm_function}{Specify which glm function to use for the marginal structural model from the \code{stats} or \code{parglm}
packages. The default function is the \code{glm} function in the \code{stats} package. Users can also specify \code{glm_function = "parglm"} such that the \code{parglm} function in the \code{parglm} package can be used for fitting generalized linear models
in parallel. The default control setting for  \code{parglm} is \code{nthreads = 4} and \code{method = "FAST"}, where four cores
and Fisher information are used for faster computation. Users can change the default control setting by passing the
arguments \code{nthreads} and \code{method} in the \code{parglm.control} function of the \code{parglm} package, or alternatively, by
passing a \code{control} argument with a list produced by \code{parglm.control(nthreads = , method = )}.}

\item{use_sample_weights}{Use case-control sampling weights in addition to inverse probability weights for treatment
and censoring. \code{data} must contain a column \code{sample_weight}. The final weights used in the pooled logistic
regression are calculated as \code{weight = weight * sample_weight}.}

\item{quiet}{Suppress the printing of progress messages and summaries of the fitted models.}

\item{...}{Additional arguments passed to \code{glm_function}. This may be used to specify initial values of parameters or
arguments to \code{control}. See \link[stats:glm]{stats::glm}, \link[parglm:parglm]{parglm::parglm} and \code{\link[parglm:parglm.control]{parglm::parglm.control()}} for more information.}
}
\value{
Object of class \code{TE_msm} containing
\describe{
\item{model}{a \code{glm} object}
\item{robust}{a list containing a summary table of estimated regression coefficients and the robust covariance
matrix}
\item{args}{a list contain the parameters used to prepare and fit the model}
}
}
\description{
Apply a weighted pooled logistic regression to fit the marginal structural model for the sequence of emulated trials
and calculates the robust covariance matrix  of parameter using the sandwich estimator.
}
\details{
The model formula is constructed by combining the arguments \code{outcome_cov}, \code{model_var},
\code{include_followup_time}, and \code{include_trial_period}.
}
