test_that("multiplication works", {
  testthat::expect_is(m3_translation(c(1, 1, 1)), "matrix")
  testthat::expect_type(m3_translation(c(1, 1, 1)), "double")
  testthat::expect_equal(dim(m3_translation(c(1, 1, 1))), c(4, 4))
  testthat::expect_error(m3_translation(NA))
  testthat::expect_error(m3_translation(NULL))
  testthat::expect_error(m3_translation("1"))
  testthat::expect_error(m3_translation(1))
  testthat::expect_error(m3_translation(c(1, 2, 3, 4)))


  testthat::expect_is(m3_euclidean_x(c(2, 2, 2), c(1, 1)), "matrix")
  testthat::expect_type(m3_euclidean_x(c(2, 2, 2), c(1, 1)), "double")
  testthat::expect_equal(dim(m3_euclidean_x(c(2, 2, 2), c(1, 1))), c(4, 4))
  testthat::expect_error(m3_euclidean_x(NA))
  testthat::expect_error(m3_euclidean_x(NULL))
  testthat::expect_error(m3_euclidean_x("1"))
  testthat::expect_error(m3_euclidean_x(1))
  testthat::expect_error(m3_euclidean_x(c(1, 2), c(1, 2, 5)))

  testthat::expect_is(m3_euclidean_y(c(2, 2, 2), c(1, 1)), "matrix")
  testthat::expect_type(m3_euclidean_y(c(2, 2, 2), c(1, 1)), "double")
  testthat::expect_equal(dim(m3_euclidean_y(c(2, 2, 2), c(1, 1))), c(4, 4))
  testthat::expect_error(m3_euclidean_y(NA))
  testthat::expect_error(m3_euclidean_y(NULL))
  testthat::expect_error(m3_euclidean_y("1"))
  testthat::expect_error(m3_euclidean_y(1))
  testthat::expect_error(m3_euclidean_y(c(1, 2), c(1, 2, 5)))


  testthat::expect_is(m3_euclidean_z(c(2, 2, 2), c(1, 1)), "matrix")
  testthat::expect_type(m3_euclidean_z(c(2, 2, 2), c(1, 1)), "double")
  testthat::expect_equal(dim(m3_euclidean_z(c(2, 2, 2), c(1, 1))), c(4, 4))
  testthat::expect_error(m3_euclidean_z(NA))
  testthat::expect_error(m3_euclidean_z(NULL))
  testthat::expect_error(m3_euclidean_z("1"))
  testthat::expect_error(m3_euclidean_z(1))
  testthat::expect_error(m3_euclidean_z(c(1, 2), c(1, 2, 5)))

  testthat::expect_is(m3_affine(c(2, 2, 2), runif(9)), "matrix")
  testthat::expect_type(m3_affine(c(2, 2, 2), runif(9)), "double")
  testthat::expect_equal(dim(m3_affine(c(2, 2, 2), runif(9))), c(4, 4))
  testthat::expect_error(m3_affine(NA))
  testthat::expect_error(m3_affine(NULL))
  testthat::expect_error(m3_affine("1"))
  testthat::expect_error(m3_affine(1))
  testthat::expect_error(m3_affine(c(1, 2), c(1, 2, 5)))

  testthat::expect_is(m3_projective(c(2, 2, 2), runif(12)), "matrix")
  testthat::expect_type(m3_projective(c(2, 2, 2), runif(12)), "double")
  testthat::expect_equal(dim(m3_projective(c(2, 2, 2), runif(12))), c(4, 4))
  testthat::expect_error(m3_projective(NA))
  testthat::expect_error(m3_projective(NULL))
  testthat::expect_error(m3_projective("1"))
  testthat::expect_error(m3_projective(1))
  testthat::expect_error(m3_projective(c(1, 2), c(1, 2, 5)))
})
