% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_files.R
\name{StringToPhyDat}
\alias{StringToPhyDat}
\alias{StringToPhydat}
\alias{PhyToString}
\alias{PhyDatToString}
\alias{PhydatToString}
\title{Convert between strings and \code{phyDat} objects}
\usage{
StringToPhyDat(string, tips, byTaxon = TRUE)

StringToPhydat(string, tips, byTaxon = TRUE)

PhyToString(
  phy,
  parentheses = "{",
  collapse = "",
  ps = "",
  useIndex = TRUE,
  byTaxon = TRUE,
  concatenate = TRUE
)

PhyDatToString(
  phy,
  parentheses = "{",
  collapse = "",
  ps = "",
  useIndex = TRUE,
  byTaxon = TRUE,
  concatenate = TRUE
)

PhydatToString(
  phy,
  parentheses = "{",
  collapse = "",
  ps = "",
  useIndex = TRUE,
  byTaxon = TRUE,
  concatenate = TRUE
)
}
\arguments{
\item{string}{String of tokens, optionally containing whitespace, with no
terminating semi-colon.}

\item{tips}{(Optional) Character vector corresponding to the names (in order)
of each taxon in the matrix, or an object such as a tree from which
tip labels can be extracted.}

\item{byTaxon}{Logical. If \code{TRUE}, write one taxon followed by the next.
If \code{FALSE}, write one character followed by the next.}

\item{phy}{An object of class \code{phyDat}.}

\item{parentheses}{Character specifying format of parentheses with which to
surround ambiguous tokens.  Choose from: \code{\{} (default), \code{[}, \code{(}, \code{<}.}

\item{collapse}{Character specifying text, perhaps \verb{,}, with which to
separate multiple tokens within parentheses.}

\item{ps}{Character specifying text, perhaps \verb{;}, to append to the end of
the string.}

\item{useIndex}{Logical (default: \code{TRUE}) specifying whether to print
duplicate characters multiple times, as they appeared in the original matrix.}

\item{concatenate}{Logical specifying whether to concatenate all
characters/taxa into a single string, or to return a separate string for
each entry.}
}
\value{
\code{StringToPhyDat()} returns an object of class \code{phyDat}.

\code{PhyToString()} returns a character vector listing a text
representation of the phylogenetic character state for each taxon in turn.
}
\description{
\code{PhyDatToString()} converts a \code{phyDat} object as a string;
\code{StringToPhyDat()} converts a string of character data to a \code{phyDat} object.
}
\examples{
StringToPhyDat("-?01231230?-", c("Lion", "Gazelle"), byTaxon = TRUE)
# encodes the following matrix:
# Lion     -?0123
# Gazelle  1230?-

fileName <- paste0(system.file(package = "TreeTools"),
                   "/extdata/input/dataset.nex")
phyDat <- ReadAsPhyDat(fileName)
PhyToString(phyDat, concatenate = FALSE)

}
\seealso{
Other phylogenetic matrix conversion functions: 
\code{\link{MatrixToPhyDat}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{phylogenetic matrix conversion functions}
