% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SplitFunctions.R
\name{Subsplit}
\alias{Subsplit}
\title{Subset of a split on fewer leaves}
\usage{
Subsplit(splits, tips, keepAll = FALSE, unique = TRUE)
}
\arguments{
\item{splits}{An object of class \code{\link[=as.Splits]{Splits}}.}

\item{tips}{A vector specifying a subset of the leaf labels applied to \code{split}.}

\item{keepAll}{logical specifying whether to keep entries that define trivial
splits (i.e. splits of zero or one leaf) on the subset of leaves.}

\item{unique}{logical specifying whether to remove duplicate splits.}
}
\value{
\code{Subsplit()} returns an object of class \code{Splits}, defined on the
leaves \code{tips}.
}
\description{
\code{Subsplit()} removes leaves from a \code{Splits} object.
}
\examples{
splits <- as.Splits(PectinateTree(letters[1:9]))
splits
efgh <- Subsplit(splits, tips = letters[5:8], keepAll = TRUE)
summary(efgh)

TrivialSplits(efgh)

summary(Subsplit(splits, tips = letters[5:8], keepAll = FALSE))
}
\seealso{
\code{\link[=KeepTip]{KeepTip()}} is a less flexible but faster equivalent.

Other split manipulation functions: 
\code{\link{DropTip}()},
\code{\link{TrivialSplits}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{split manipulation functions}
