% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_properties.R
\name{NSplits}
\alias{NSplits}
\alias{NPartitions}
\alias{NSplits.phylo}
\alias{NSplits.multiPhylo}
\alias{NSplits.list}
\alias{NSplits.Splits}
\alias{NSplits.numeric}
\title{Number of distinct splits}
\usage{
NSplits(x)

NPartitions(x)

\method{NSplits}{phylo}(x)

\method{NSplits}{multiPhylo}(x)

\method{NSplits}{list}(x)

\method{NSplits}{Splits}(x)

\method{NSplits}{numeric}(x)
}
\arguments{
\item{x}{A phylogenetic tree of class \code{phylo}, or a list of such trees
(of class \code{list} or \code{multiPhylo}), or a \code{Splits} object,
or a vector of integers.}
}
\value{
\code{NSplits()} returns an integer specifying the number of bipartitions in
the specified objects, or in a binary tree with \code{x} tips.
}
\description{
\code{NSplits()} counts the unique bipartition splits in a tree or object.
}
\examples{
NSplits(8L)
NSplits(PectinateTree(8))
NSplits(as.Splits(BalancedTree(8)))
}
\seealso{
Other tree properties: 
\code{\link{ConsensusWithout}()},
\code{\link{NTip}()},
\code{\link{SplitsInBinaryTree}()},
\code{\link{TipLabels}()},
\code{\link{TreeIsRooted}()}

Other Splits operations: 
\code{\link{NTip}()},
\code{\link{SplitsInBinaryTree}()},
\code{\link{TipLabels}()},
\code{\link{TipsInSplits}()},
\code{\link{as.Splits}()},
\code{\link{match}()}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{Splits operations}
\concept{tree properties}
