% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IWScore.R, R/TreeSearch.R, R/pp_ProfileScore.R
\name{IWTreeSearch}
\alias{IWTreeSearch}
\alias{EdgeListSearch}
\alias{TreeSearch}
\alias{ProfileTreeSearch}
\title{Search for most parsimonious trees}
\usage{
IWTreeSearch(tree, dataset, concavity = 4, EdgeSwapper = RootedTBR,
  maxIter = 100, maxHits = 20, forestSize = 1, verbosity = 1, ...)

EdgeListSearch(edgeList, dataset, TreeScorer = MorphyLength,
  EdgeSwapper = RootedTBRSwap, maxIter = 100, maxHits = 20,
  bestScore = NULL, stopAtScore = NULL, stopAtPeak = FALSE,
  stopAtPlateau = 0L, forestSize = 1L, cluster = NULL,
  verbosity = 1L, ...)

TreeSearch(tree, dataset, InitializeData = PhyDat2Morphy,
  CleanUpData = UnloadMorphy, TreeScorer = MorphyLength,
  EdgeSwapper = RootedTBRSwap, maxIter = 100L, maxHits = 20L,
  forestSize = 1L, stopAtPeak = FALSE, stopAtPlateau = 0L,
  verbosity = 1L, ...)

ProfileTreeSearch(tree, dataset, EdgeSwapper = RootedTBR,
  maxIter = 100, maxHits = 20, forestSize = 1, verbosity = 1,
  precision = 40000, ...)
}
\arguments{
\item{tree}{a fully-resolved starting tree in \code{\link{phylo}} format, with the desired outgroup; edge lengths are not supported and will be deleted;}

\item{dataset}{Data in format required by \code{InitializeData}.}

\item{concavity}{A numeric value to use as the concavity constant (\code{k}) in implied weighting.}

\item{EdgeSwapper}{a function that rearranges a parent and child vector,
and returns a list with modified vectors; for example
\code{\link{SPRSwap}}.}

\item{maxIter}{the maximum number of iterations to perform before abandoning the search.}

\item{maxHits}{the maximum times to hit the best pscore before abandoning the search.}

\item{forestSize}{the maximum number of trees to return - useful in concert with \code{\link{consensus}}.}

\item{verbosity}{Level of detail to display in console: larger numbers provide
more verbose feedback to the user.}

\item{\dots}{further arguments to pass to \code{TreeScorer} function
(e.g. \code{\link{TipsAreColumns}}, \code{dataset})}

\item{edgeList}{a list containing the following:
- vector of integers corresponding to the parent of each edge in turn
- vector of integers corresponding to the child of each edge in turn
- (optionally) score of the tree
- (optionally, if score provided) number of times this score has been hit}

\item{TreeScorer}{function to score a given tree.
The function will be passed three parameters, corresponding to the
\code{parent} and \code{child} entries of a tree's edge list, and a dataset.}

\item{stopAtPeak}{Logical specifying whether to terminate search once a subsequent
iteration recovers a sub-optimal score. Useful with methods that
return all trees one rearrangement from the current tree, such
as \code{\link{AllTBR}}.  Will be overridden if a passed function
has an attribute \code{stopAtPeak} set by
\code{attr(FunctionName, 'stopAtPeak') <- TRUE}.}

\item{stopAtPlateau}{Integer. If > 0, tree search will terminate if the score
has not improved after \code{stopAtPlateau} iterations.
Useful with methods that return all trees one
rearrangement from the current tree, such as
\code{\link{AllTBR}}.
Will be overridden if a passed function has an attribute
\code{stopAtPlateau} set by \code{attr(FunctionName, 'stopAtPlateau') <- TRUE}.}

\item{InitializeData}{Function that sets up data object to prepare for tree search.
The function will be passed the \kbd{dataset} parameter.
Its return value will be passed to TreeScorer and CleanUpData.}

\item{CleanUpData}{Function to destroy data object on function exit.
The function will be passed the value returned by \kbd{InitializeData}.}

\item{dataset}{A phylogenetic data matrix of class \code{\link[phangorn]{phyDat}},
whose names correspond to the labels of any accompanying tree.}
}
\value{
{
This function returns a tree, with an attribute \code{pscore} conveying its parsimony score.
Note that the parsimony score will be inherited from the tree's attributes, which is only valid if it
was generated using the same \code{data} that is passed here.
}
}
\description{
Run standard search algorithms (\acronym{NNI}, \acronym{SPR} or \acronym{TBR})
to search for a more parsimonious tree.
}
\section{Functions}{
\itemize{
\item \code{IWTreeSearch}: Search using profile parsimony

\item \code{EdgeListSearch}: Tree Search from Edge lists

\item \code{ProfileTreeSearch}: Search using profile parsimony
}}

\examples{
data('Lobo')
njtree <- NJTree(Lobo.phy)

\dontrun{
TreeSearch(njtree, Lobo.phy, maxIter=20, EdgeSwapper=NNISwap)
TreeSearch(njtree, Lobo.phy, maxIter=20, EdgeSwapper=RootedSPRSwap)
TreeSearch(njtree, Lobo.phy, maxIter=20, EdgeSwapper=TBRSwap)}

}
\seealso{
\itemize{
\item \code{\link{Fitch}}, calculates parsimony score;
\item \code{\link{RootedNNI}}, conducts tree rearrangements;
\item \code{\link{Ratchet}}, alternative heuristic, useful to escape local optima.
}
}
\author{
Martin R. Smith

Martin R. Smith
}
\keyword{internal}
\keyword{tree}
