% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{readTLS}
\alias{readTLS}
\title{Import a point cloud file into a LAS object}
\usage{
readTLS(file, colNames = NULL, ...)
}
\arguments{
\item{file}{file path.}

\item{colNames}{optional - \code{character} vector. Only used for table-like files. It states the column names - if not set, only the 3 first columns will be converted to XYZ.}

\item{...}{further arguments passed to either \code{readLAS} or \code{read.table}.}
}
\value{
\code{LAS} object.
}
\description{
Wrapper to read point clouds straight to LAS objects suitable for TLS applications. Reads \emph{las} or \emph{laz} files with \code{\link[lidR:readLAS]{readLAS}} and alters the header defaults. Other file formats are (or try to be) read using \code{\link[utils:read.table]{read.table}}.
}
\examples{
file = system.file("extdata", "pine.laz", package="TreeLS")
tls = readTLS(file)
summary(tls)
}
