% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LAI_deciduous.R
\name{LAI_deciduous}
\alias{LAI_deciduous}
\title{LAI_deciduous - Generates hourly data of leaf and bark area index for deciduous trees in a specific year}
\usage{
LAI_deciduous(Year, BAI_value, LAI_value, day_decay_ini, month_decay_ini,
  days_duration_decay, day_emergence_ini, month_emergence_ini,
  days_duration_emergence)
}
\arguments{
\item{Year}{Year to generate leaf and bark area index (e.g. 2015)}

\item{BAI_value}{Bark area index value (e.g. 0.1)}

\item{LAI_value}{Maximum value of leaf area index value (e.g. 1.5)}

\item{day_decay_ini}{Day of the month leaves start to decay (between 1 and 31; e.g., 15)}

\item{month_decay_ini}{Month of the year leaves start to decay (between 1 and 12; e.g., 10)}

\item{days_duration_decay}{The duration of leaf decay in number of days (e.g., 50)}

\item{day_emergence_ini}{Day of the month leaves start to emerge (between 1 and 31; e.g., 1)}

\item{month_emergence_ini}{Month of the year leaves start to emerge (between 1 and 12; e.g., 4)}

\item{days_duration_emergence}{The duration of leaf emergence in number of days (e.g., 20)}
}
\value{
A dataframe with LAI and BAI hourly values is generated
}
\description{
LAI_deciduous - Generates hourly data of leaf and bark area index for deciduous trees in a specific year
}
\examples{

LAI_deciduous(Year = 2016,
BAI_value = 0.1,
LAI_value = 1.5,
day_decay_ini = 15,
month_decay_ini = 10,
days_duration_decay = 100,
day_emergence_ini = 1,
month_emergence_ini = 4,
days_duration_emergence = 20)

}
