% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export}
\alias{export}
\title{export}
\usage{
export(
  andromeda,
  outputPath,
  ageWindow = 10,
  minCellCount = 5,
  censorType = "minCellCount",
  archiveName = NULL
)
}
\arguments{
\item{andromeda}{(\code{Andromeda::andromeda()})
Andromeda object.}

\item{outputPath}{(\code{character(1)})\cr}

\item{ageWindow}{(\code{integer(1)}: \code{10})\cr
Number of years to bin age groups into.}

\item{minCellCount}{(\code{integer(1)}: \code{5})\cr
Minimum count required per pathway. Censors data below \code{x} as \verb{<x}. This
minimum value will carry over to the sankey diagram and sunburst plot.}

\item{censorType}{(\code{character(1)})\cr
\describe{
\item{\code{"minCellCount"}}{Censors pathways <\code{minCellCount} to \code{minCellCount}.}
\item{\code{"remove"}}{Censors pathways <\code{minCellCount} by removing them completely.}
\item{\code{"mean"}}{Censors pathways <\code{minCellCount} to the mean of all frequencies below \code{minCellCount}}
}}

\item{archiveName}{(\code{character(1)}: \code{NULL})\cr
If not \code{NULL} adds the exported files to a ZIP-file with the specified archive name.}
}
\value{
(\code{invisible(NULL)})
}
\description{
Export andromeda generated by \link[TreatmentPatterns]{computePathways}
object to sharable csv-files and/or a zip archive.
}
\examples{
\donttest{
library(TreatmentPatterns)
library(CDMConnector)
library(dplyr)

if (require("CirceR", character.only = TRUE, quietly = TRUE)) {
  withr::local_envvar(
    EUNOMIA_DATA_FOLDER = Sys.getenv("EUNOMIA_DATA_FOLDER", unset = tempfile())
  )

  downloadEunomiaData(overwrite = TRUE)

  con <- DBI::dbConnect(duckdb::duckdb(), dbdir = eunomia_dir())
  cdm <- cdmFromCon(con, cdmSchema = "main", writeSchema = "main")

  cohortSet <- readCohortSet(
    path = system.file(package = "TreatmentPatterns", "exampleCohorts")
  )

  cdm <- generateCohortSet(
    cdm = cdm,
    cohortSet = cohortSet,
    name = "cohort_table"
  )

  cohorts <- cohortSet \%>\%
    # Remove 'cohort' and 'json' columns
    select(-"cohort", -"json") \%>\%
    mutate(type = c("event", "event", "event", "event", "exit", "event", "event", "target")) \%>\%
    rename(
      cohortId = "cohort_definition_id",
      cohortName = "cohort_name",
    )

  outputEnv <- computePathways(
    cohorts = cohorts,
    cohortTableName = "cohort_table",
    cdm = cdm
  )

  export(
    andromeda = outputEnv,
    outputPath = tempdir()
  )

  Andromeda::close(outputEnv)
  DBI::dbDisconnect(con, shutdown = TRUE)
}
}
}
