% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Theta.est.R
\name{Theta.est}
\alias{Theta.est}
\title{Sparse precision matrix estimation.}
\usage{
Theta.est(S.hat.A, delta.hat, lam2=0.1, Omega.hat0=NULL,
                 n=100, max_iter=10, eps=1e-3, method = "cd")
}
\arguments{
\item{S.hat.A}{The sample covariance matrix.}

\item{delta.hat}{The divergence matrix estimated in step 2(a). If the precision matrix is estimated in the common case (Liu and Luo, 2015, JMVA), it can be set to zero matrix.}

\item{lam2}{A float value, a tuning parameter.}

\item{Omega.hat0}{The initial values of the precision matrix, which can be unspecified.}

\item{n}{The sample size.}

\item{max_iter}{Int, maximum number of cycles of the algorithm.}

\item{eps}{A float value, algorithm termination threshold.}

\item{method}{The optimization algorithm, which can be selected as "admm" (ADMM algorithm) or "cd" (coordinate descent).}
}
\value{
A result list including:
\describe{
\item{Theta.hat.m}{The optimal precision matrix.}
\item{BIC.summary}{The summary of BICs.}
\item{Theta.hat.list.m}{The precision matrices corresponding to a sequence of tuning parameters.}
}
}
\description{
The fast sparse precision matrix estimation in step 2(b).
}
\examples{
p = 20
n = 200
omega = diag(rep(1,p))
for (i in 1:p) {
  for (j in 1:p) {
    omega[i,j] = 0.3^(abs(i-j))*(abs(i-j) < 2)
  }
}
Sigma = solve(omega)
X = MASS::mvrnorm(n, rep(0,p), Sigma)
S.hat.A = cov(X)
delta.hat = diag(rep(1,p)) - diag(rep(1,p))
omega.hat = Theta.est(S.hat.A, delta.hat, lam2=0.2)



}
\references{
Ren, M., Zhen Y., and Wang J. (2022). Transfer learning for tensor graphical models.
Liu, W. and Luo X. (2015). Fast and adaptive sparse precision matrix estimation in high dimensions, Journal of Multivariate Analysis.
}
\author{
Mingyang Ren \href{mailto:renmingyang17@mails.ucas.ac.cn}{renmingyang17@mails.ucas.ac.cn}.
}
