% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Thist.R
\name{Thist}
\alias{Thist}
\title{Histograms with overlays}
\usage{
Thist(x, overlay = "normal", col = "gray80", ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{overlay}{Either "normal" (default) or "density" indicating whether a normal distribution or density curve should be plotted on top of the histogram.}

\item{col}{Color of the histogram bars.}

\item{...}{Other arguments to be passed to \code{hist()}.}
}
\description{
Plot a histogram with either a normal distribution or density curve overlay.
}
\examples{
set.seed(42)
x <- rnorm(1000, mean=5, sd=2)
Thist(x)
Thist(x, overlay="density")
Thist(x^2)
Thist(x^2, overlay="density", breaks=50, col="lightblue2")

}
\author{
Stephen Turner
}
\keyword{NA}

