#############################################################################
##
##  Auxiliary Functions.
##
#############################################################################

## --------------------------------------------------------------------------

## The implementation of R's built-in function isTRUE() is annoying.
## Thus we define our own.
is.TRUE <- function(x) { identical(TRUE, as.logical(x)) }

## --------------------------------------------------------------------------

arc.mean <- function(x,y) {
  ## ------------------------------------------------------------------------
  ## Compute "arc-mean" of two points.
  ## ------------------------------------------------------------------------
  ##   x, y ... two points
  ## ------------------------------------------------------------------------
  ## return: arc-mean
  ## ------------------------------------------------------------------------

  ## We need x < y.
  p <- sort(c(x,y))

  if (p[2] < -1.e3 || p[1] > 1.e3)
    ## Use harmonic mean.
    return (2./(1./p[1] + 1./p[2]))

  a = atan(p)
  if (abs(a[1]-a[2]) < 1.e-6)
    ## Use arithmetic mean.
    return (0.5*p[1] + 0.5*p[2])

  ## Use "arc mean",
  return (tan(0.5*a[1] + 0.5*a[2]))
}

## --------------------------------------------------------------------------
