% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-aic-normal.R
\name{util_normal_aic}
\alias{util_normal_aic}
\title{Calculate Akaike Information Criterion (AIC) for Normal Distribution}
\usage{
util_normal_aic(.x)
}
\arguments{
\item{.x}{A numeric vector containing the data to be fitted to a normal distribution.}
}
\value{
The AIC value calculated based on the fitted normal distribution to the provided data.
}
\description{
This function estimates the parameters of a normal distribution from the provided data using maximum likelihood estimation,
and then calculates the AIC value based on the fitted distribution.
}
\details{
This function calculates the Akaike Information Criterion (AIC) for a normal distribution fitted to the provided data.
}
\examples{
# Example 1: Calculate AIC for a sample dataset
set.seed(123)
data <- rnorm(30)
util_normal_aic(data)

}
\seealso{
Other Utility: 
\code{\link{check_duplicate_rows}()},
\code{\link{convert_to_ts}()},
\code{\link{quantile_normalize}()},
\code{\link{tidy_mcmc_sampling}()},
\code{\link{util_beta_aic}()},
\code{\link{util_binomial_aic}()},
\code{\link{util_cauchy_aic}()},
\code{\link{util_chisq_aic}()},
\code{\link{util_exponential_aic}()},
\code{\link{util_gamma_aic}()},
\code{\link{util_geometric_aic}()},
\code{\link{util_hypergeometric_aic}()},
\code{\link{util_logistic_aic}()},
\code{\link{util_lognormal_aic}()},
\code{\link{util_pareto_aic}()},
\code{\link{util_poisson_aic}()},
\code{\link{util_uniform_aic}()},
\code{\link{util_weibull_aic}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
