% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-aic-beta.R
\name{util_beta_aic}
\alias{util_beta_aic}
\title{Calculate Akaike Information Criterion (AIC) for Beta Distribution}
\usage{
util_beta_aic(.x)
}
\arguments{
\item{.x}{A numeric vector containing the data to be fitted to a beta
distribution.}
}
\value{
The AIC value calculated based on the fitted beta distribution to the
provided data.
}
\description{
This function estimates the parameters of a beta distribution from the provided
data using maximum likelihood estimation, and then calculates the AIC value
based on the fitted distribution.
}
\details{
This function calculates the Akaike Information Criterion (AIC) for a beta
distribution fitted to the provided data.

Initial parameter estimates: The choice of initial values can impact the
convergence of the optimization.

Optimization method: You might explore different optimization methods within
optim for potentially better performance.
Data transformation: Depending on your data, you may need to apply
transformations (e.g., scaling to \verb{[0,1]} interval) before fitting the beta
distribution.

Goodness-of-fit: While AIC is a useful metric for model comparison, it's
recommended to also assess the goodness-of-fit of the chosen model using
visualization and other statistical tests.
}
\examples{
# Example 1: Calculate AIC for a sample dataset
set.seed(123)
x <- rbeta(30, 1, 1)
util_beta_aic(x)

}
\seealso{
Other Utility: 
\code{\link{check_duplicate_rows}()},
\code{\link{convert_to_ts}()},
\code{\link{quantile_normalize}()},
\code{\link{tidy_mcmc_sampling}()},
\code{\link{util_binomial_aic}()},
\code{\link{util_cauchy_aic}()},
\code{\link{util_chisq_aic}()},
\code{\link{util_exponential_aic}()},
\code{\link{util_gamma_aic}()},
\code{\link{util_geometric_aic}()},
\code{\link{util_hypergeometric_aic}()},
\code{\link{util_logistic_aic}()},
\code{\link{util_lognormal_aic}()},
\code{\link{util_normal_aic}()},
\code{\link{util_pareto_aic}()},
\code{\link{util_poisson_aic}()},
\code{\link{util_uniform_aic}()},
\code{\link{util_weibull_aic}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
