% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random-tidy-normal-inverse.R
\name{tidy_inverse_normal}
\alias{tidy_inverse_normal}
\title{Tidy Randomly Generated Inverse Gaussian Distribution Tibble}
\usage{
tidy_inverse_normal(
  .n = 50,
  .mean = 1,
  .shape = 1,
  .dispersion = 1/.shape,
  .num_sims = 1
)
}
\arguments{
\item{.n}{The number of randomly generated points you want.}

\item{.mean}{Must be strictly positive.}

\item{.shape}{Must be strictly positive.}

\item{.dispersion}{An alternative way to specify the \code{.shape}.}

\item{.num_sims}{The number of randomly generated simulations you want.}
}
\value{
A tibble of randomly generated data.
}
\description{
This function will generate \code{n} random points from an Inverse Gaussian
distribution with a user provided, \code{.mean}, \code{.shape}, \code{.dispersion}The function
returns a tibble with the simulation number column the x column which corresponds
to the n randomly generated points.

The data is returned un-grouped.

The columns that are output are:
\itemize{
\item \code{sim_number} The current simulation number.
\item \code{x} The current value of \code{n} for the current simulation.
\item \code{y} The randomly generated data point.
\item \code{dx} The \code{x} value from the \code{\link[stats:density]{stats::density()}} function.
\item \code{dy} The \code{y} value from the \code{\link[stats:density]{stats::density()}} function.
\item \code{p} The values from the resulting p_ function of the distribution family.
\item \code{q} The values from the resulting q_ function of the distribution family.
}
}
\details{
This function uses the underlying \code{actuar::rinvgauss()}. For
more information please see \code{\link[=rinvgauss]{rinvgauss()}}
}
\examples{
tidy_inverse_normal()
}
\seealso{
Other Continuous Distribution: 
\code{\link{tidy_beta}()},
\code{\link{tidy_burr}()},
\code{\link{tidy_cauchy}()},
\code{\link{tidy_chisquare}()},
\code{\link{tidy_exponential}()},
\code{\link{tidy_f}()},
\code{\link{tidy_gamma}()},
\code{\link{tidy_generalized_beta}()},
\code{\link{tidy_generalized_pareto}()},
\code{\link{tidy_geometric}()},
\code{\link{tidy_inverse_burr}()},
\code{\link{tidy_inverse_exponential}()},
\code{\link{tidy_inverse_gamma}()},
\code{\link{tidy_inverse_pareto}()},
\code{\link{tidy_inverse_weibull}()},
\code{\link{tidy_logistic}()},
\code{\link{tidy_lognormal}()},
\code{\link{tidy_normal}()},
\code{\link{tidy_paralogistic}()},
\code{\link{tidy_pareto1}()},
\code{\link{tidy_pareto}()},
\code{\link{tidy_t}()},
\code{\link{tidy_uniform}()},
\code{\link{tidy_weibull}()},
\code{\link{tidy_zero_truncated_geometric}()}

Other Gaussian: 
\code{\link{tidy_normal}()},
\code{\link{util_normal_param_estimate}()},
\code{\link{util_normal_stats_tbl}()}

Other Inverse Distribution: 
\code{\link{tidy_inverse_burr}()},
\code{\link{tidy_inverse_exponential}()},
\code{\link{tidy_inverse_gamma}()},
\code{\link{tidy_inverse_pareto}()},
\code{\link{tidy_inverse_weibull}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Continuous Distribution}
\concept{Gaussian}
\concept{Inverse Distribution}
