% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_distribution_summary_tbl.R
\name{tidy_distribution_summary_tbl}
\alias{tidy_distribution_summary_tbl}
\title{Tidy Distribution Summary Statistics Tibble}
\usage{
tidy_distribution_summary_tbl(.data)
}
\arguments{
\item{.data}{The data that is going to be passed from a a \code{tidy_} distribution
function.}
}
\value{
A summary stats tibble
}
\description{
This function returns a summary statistics tibble. It will use the
y column from the \code{tidy_} distribution function.
}
\details{
This function takes in a \code{tidy_} distribution table and
will return a tibble of the following information:
\itemize{
\item \code{sim_number}
\item \code{mean_val}
\item \code{median_val}
\item \code{std_val}
\item \code{min_val}
\item \code{max_val}
\item \code{skewness}
\item \code{kurtosis}
\item \code{range}
\item \code{iqr}
\item \code{variance}
}

The kurtosis and skewness come from the package \code{healthyR.ai}
}
\examples{
tn <- tidy_normal(.num_sims = 5)
tidy_distribution_summary_tbl(tn)

}
\author{
Steven P. Sanderson II, MPH
}
\concept{Summary Statistics}
\concept{Table Data}
