% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVoltageCurve.R
\name{plot_voltageCurve}
\alias{plot_voltageCurve}
\title{Plot the V-DeltaT Curve}
\usage{
plot_voltageCurve(Tdata, OnlyTarget = TRUE, Pdata = NULL)
}
\arguments{
\item{Tdata}{a vector of temperature-change values}

\item{OnlyTarget}{logical. If \code{TRUE}, plot the target curve only.}

\item{Pdata}{the values returning by \code{voltageCurve} or
\code{tempCompCurve}}
}
\value{
the graph
}
\description{
Plot the temperature-change-voltage curve under a particular
   components setting v.s. the target curve. using \code{ggplot}.
}
\examples{
### only target curve
Tdata <- seq(-40, 85, by = 5)
plot_voltageCurve(Tdata)
### a particular curve and the target curve
data(CompValues)
Tdata <- seq(-40, 85, by=5)
R_id <- c(43, 36, 29, 15, 9, 3)
Res <- CompValues$Res
ThVal <- CompValues$ThVal
ThBeta <- CompValues$ThBeta
Vnew <- voltageCurve(Tdata, R_id, Res, ThVal, ThBeta)
plot_voltageCurve(Tdata, OnlyTarget = FALSE, Pdata = Vnew)
}
