% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MI_index.R
\name{MI_index}
\alias{MI_index}
\title{Mixture Index ("MI")}
\usage{
MI_index(
  x,
  plot = FALSE,
  Trait = 1,
  B = NULL,
  CI = 0.95,
  p.f = 0,
  index_type = "MI",
  rand = TRUE,
  digits = 4
)
}
\arguments{
\item{x}{A data frame containing summary statistics.}

\item{plot}{logical; if true a plot of densities for both sexes is returned,
Default: FALSE}

\item{Trait}{Number of the column containing names of measured parameters,
Default: 1}

\item{B}{number of bootstrap samples for generating confidence intervals. Higher
number means greater accuracy but slower execution. If NULL bootstrap confidence
intervals are not produced, Default:NULL}

\item{CI}{confidence interval coverage takes value from 0 to 1, Default: 0.95.}

\item{p.f}{proportion of sample that is female (if p.f>0 then
p.m=1-p.f, where p.m is the proportion of males and bootstrap won't
be available) , Default: 0}

\item{index_type}{type of coefficient (if "MI" it fits the mixture index.
If = "NI" it fits the overlap coefficient for two normal distributions,
which is equal to 1 – D_index, Default: 'MI'}

\item{rand}{logical; if TRUE, uses random seed.  If FALSE, then set.seed(42)
for repeatability, Default: TRUE}

\item{digits}{Number of significant digits, Default: 4}
}
\value{
returns a table of Ipina and Durand's (2010) mixture index ("MI")
for different traits with graphical representation.
}
\description{
Ipina and Durand's (2010) mixture intersection (MI) measure of
sexual dimorphism.  This measure is an overlap coefficient where the sum of
 the frequency of males and the frequency of females equals 1.0.  Ipina and
 Durand (2010) also define a normal intersection (NI) measure which is the
 overlap coefficient of two normal distributions, equivalent to Inman and
 Bradley's (1989) overlap coefficient
}
\details{
see \link{D_index} for bootstrap method.
}
\examples{
library(TestDimorph)
data("Cremains_measurements")
# plot and test of significance
MI_index(Cremains_measurements[1, ], plot = TRUE)
#' #NI index
MI_index(Cremains_measurements[1, ], index_type = "NI")
\dontrun{
# confidence interval was bootstrapping
MI_index(Cremains_measurements[1, ], rand = FALSE, B = 1000)
}
}
\references{
Inman, H. F., & Bradley Jr, E. L. (1989). The overlapping
coefficient as a measure of agreement between probability distributions and
point estimation of the overlap of two normal densities. Communications in
Statistics-Theory and Methods, 18(10), 3851-3874.

Ipina, S. L., & Durand, A. I. (2010). Assessment of sexual dimorphism: a
critical discussion in a (paleo-) anthropological context. Human Biology,
82(2), 199-220.
}
