% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_data_cache_operators.r
\docType{methods}
\name{makeSimulationDataCache}
\alias{makeSimulationDataCache}
\alias{makeSimulationDataCache,item_pool-method}
\title{Create a simulation data cache object}
\usage{
makeSimulationDataCache(
  item_pool,
  info_type = "FISHER",
  theta_grid = seq(-4, 4, 0.1),
  seed = NULL,
  true_theta = NULL,
  response_data = NULL
)

\S4method{makeSimulationDataCache}{item_pool}(
  item_pool,
  info_type = "FISHER",
  theta_grid = seq(-4, 4, 0.1),
  seed = NULL,
  true_theta = NULL,
  response_data = NULL
)
}
\arguments{
\item{item_pool}{an \code{\linkS4class{item_pool}} object.}

\item{info_type}{the type of information.}

\item{theta_grid}{a grid of theta values.}

\item{seed}{(optional) seed to use for generating response data if needed.}

\item{true_theta}{(optional) true theta values of all simulees.}

\item{response_data}{(optional) response data on all items for all simulees.}
}
\description{
\code{\link{makeSimulationDataCache}} is a function for creating a \code{\linkS4class{simulation_data_cache}} object.
This is used in \code{\link{Shadow}} to make all necessary data (e.g., item information, response data) prior to the main simulation.
}
