% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenGamma.R
\name{fit.GenGamma}
\alias{fit.GenGamma}
\title{Generalized Gamma Distribution Parameter Estimation}
\usage{
fit.GenGamma(
  time,
  status,
  sig = 0.05,
  tau = NULL,
  init,
  bL = 0.1,
  bU = 10,
  eps = 1e-06,
  maxit = 10,
  report = FALSE
)
}
\arguments{
\item{time}{Numeric observation times.}

\item{status}{Status indicator, coded as 1 if an event was observed, 0 if censored.}

\item{sig}{Significance level, for CIs.}

\item{tau}{Optional truncation times for calculating RMSTs.}

\item{init}{Vector of initial values for the shape \eqn{\alpha}, \eqn{\beta}, and
rate \eqn{\lambda} parameters, respectively.}

\item{bL}{Lower limit on possible values for beta.}

\item{bU}{Upper limit on possible values for beta.}

\item{eps}{Tolerance for Newton-Raphson iterations.}

\item{maxit}{Maximum number of NR iterations.}

\item{report}{Report fitting progress?}
}
\value{
An object of class \code{fit} containing the following:
\describe{
 \item{Parameters}{The estimated shape \eqn{(\alpha,\beta)} and rate \eqn{\lambda} parameters.}
 \item{Information}{The observed information matrix.}
 \item{Outcome}{The fitted mean, median, and variance.}
 \item{RMST}{The estimated RMSTs, if tau was specified.}
}
}
\description{
Estimates parameters for generalized gamma event times subject to non-informative
right censoring. The gamma distribution is parameterized in terms
of the shape parameters \eqn{(\alpha,\beta)}, and the rate \eqn{\lambda}:
\deqn{f(t) = \frac{\beta\lambda}{\Gamma(\alpha)} (\lambda t)^{\alpha\beta-1}e^{-(\lambda t)^{\beta}}, t>0}
}
\examples{
set.seed(103);
# Generalized Gamma data with 20\% censoring.
data = genData(n=1e4,dist="gen-gamma",theta=c(2,2,2),p=0.2);
# Estimate
fit = fitParaSurv(time=data$time,status=data$status,dist="gen-gamma",report=TRUE);
}
\seealso{
\itemize{
  \item{Fitting function for parametric survival distributions \code{\link{fitParaSurv}}}
}
}
