% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TempleMetrics.R
\name{Fycondx.DR}
\alias{Fycondx.DR}
\title{Fycondx.DR}
\usage{
\method{Fycondx}{DR}(object, yvals, xdf)
}
\arguments{
\item{object}{a distribution regression object}

\item{yvals}{the values to compute the ecdf for}

\item{xdf}{a dataframe (can contain multiple rows) with x values}
}
\value{
an ecdf for each value of the x's
}
\description{
take a particular value of y and predict F(y|x)
}
\examples{
data(igm)
yvals <- seq(quantile(igm$lcfincome,.05,type=1),
 quantile(igm$lcfincome,.95, type=1), length.out=100)
dres <- distreg(lcfincome ~ lfincome + HEDUC, igm, yvals)
xdf <- data.frame(lfincome=10, HEDUC=c("LessHS","HS"))
d <- Fycondx(dres, yvals, xdf)
d
y0 <- yvals[50]
d[[1]](y0)

}
