% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS_extended.R
\name{rKRTS}
\alias{rKRTS}
\title{Function to generate random variates of KRTS distribution.}
\usage{
rKRTS(
  n,
  alpha = NULL,
  kp = NULL,
  km = NULL,
  rp = NULL,
  rm = NULL,
  pp = NULL,
  pm = NULL,
  mu = NULL,
  theta = NULL,
  methodR = "SR",
  k = 10000
)
}
\arguments{
\item{n}{sample size (integer).}

\item{alpha}{Stability parameter. A real number between 0 and 2.}

\item{kp, km, rp, rm}{Parameter of KR-distribution. A real number \code{>0}.}

\item{pp, pm}{Parameter of KR-distribution. A real number \code{>-alpha}.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}

\item{methodR}{A String. Only "SR" is available here.}

\item{k}{integer: the level of truncation, if \code{methodR == "SR"}. 10000
by default.}
}
\value{
Generates \code{n} random numbers of the KRTS distribution.
}
\description{
Generates \code{n} random numbers distributed according to the Kim-Rachev
tempered stable (KRTS) distribution.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, kp, km,
rp, rm, pp. pm, mu)}. Either provide the parameters individually OR
provide \code{theta}.
"SR" stands for a truncated infinite shot noise series representation.
Currently, this method is the only implemented to generate random variates.
The series representation is given by Bianchi et a. (2010).

It is recommended to check the generated random numbers once for each
distribution using the density function. If the random numbers are shifted,
e.g. for the method "SR", it may be worthwhile to increase k.

For more details, see references.
}
\examples{
rKRTS(1,0.5,1,1,1,1,1,1,0,NULL,"SR")

}
\references{
Bianchi, M. L.; Rachev, S. T.; Kim, Y. S. & Fabozzi, F. J. (2010), 'Tempered
stable distributions and processes in finance: Numerical analysis'
\doi{10.1007/978-88-470-1481-7}
}
