% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_error.R
\name{report_error}
\alias{report_error}
\alias{report2console}
\title{Report errors to console}
\usage{
report2console(file = NULL, line_no = NULL, column = NULL,
  context = NULL, error_message = NULL, advice = NULL,
  build_status = NULL, extra_cat_ante = NULL, extra_cat_post = NULL,
  rstudio = FALSE, log_file = NULL, silent = FALSE,
  halt = getOption("TeXCheckR.halt_on_error", FALSE))
}
\arguments{
\item{file}{The file in which the error occurred.}

\item{line_no}{The line number locating the source of the error.}

\item{column}{The position on the line to identify the error (usually following the error).}

\item{context}{The content of the file, to provide context to the error.}

\item{error_message}{The error message to display beyond the console.}

\item{advice}{Advice to the user: how should the detected error be resolved in general?}

\item{build_status}{What should the build status be reported as?}

\item{extra_cat_ante}{Character vector extra messages (placed before \code{context}).}

\item{extra_cat_post}{Character vector extra messages (placed after \code{context}).}

\item{rstudio}{If available, should the report be allowed to modify the RStudio session (for example, to pop to the location of the error)?}

\item{log_file}{Optionally, path to a log file on which \code{error_message} will be written.}

\item{silent}{(logical, default: \code{FALSE}) Suppress all output.}

\item{halt}{Should failures halt via \code{stop} or just display a message in the console?}
}
\description{
Report errors to console
}
