% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_functions.R
\name{ts_to_prophet}
\alias{ts_to_prophet}
\title{Transform Time Series Object to Prophet input}
\usage{
ts_to_prophet(ts.obj, start = NULL)
}
\arguments{
\item{ts.obj}{A univariate time series object of a class "ts", "zoo", "xts", with a daily, weekly, monthly , quarterly or yearly frequency}

\item{start}{A date object (optional), if the starting date of the series is known. Otherwise, the date would be derive from the series index}
}
\value{
A data frame object
}
\description{
Transform a time series object to Prophet data frame input format
}
\examples{

data(USgas)

ts_to_prophet(ts.obj = USgas)

# If known setting the start date of the input object

ts_to_prophet(ts.obj = USgas, start = as.Date("2000-01-01"))

}
