% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.TSVC.R
\name{plot.TSVC}
\alias{plot.TSVC}
\title{Plotting of Varying Coefficient Trees}
\usage{
\method{plot}{TSVC}(
  x,
  variable,
  cex.lines = 2,
  cex.branches = 1,
  cex.coefs = 1,
  cex.main = 1,
  title = NULL,
  ...
)
}
\arguments{
\item{x}{object of class \code{\link[TSVC]{TSVC}}.}

\item{variable}{name of the variable, for which the tree shall be plotted.}

\item{cex.lines}{width of branches of the tree.}

\item{cex.branches}{size of the labels of the tree.}

\item{cex.coefs}{size of the coefficients in the terminal nodes of the tree.}

\item{cex.main}{size of the title of the tree.}

\item{title}{optional title, which is addded to the tree; if \code{title=NULL} the title is the name of the variable in the data.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Visualization of trees of effects of covariates that vary with the values of one or several effect modifiers.
}
\examples{
# Swiss Labour Market 
library(AER)
data("SwissLabor")

# recode factors 
sl <- SwissLabor
sl$participation <- as.numeric(sl$participation)-1
sl$foreign       <- as.numeric(sl$foreign)-1

\dontrun{
fit1 <- TSVC(participation~income+age, data=sl, family=binomial(link="logit"), 
             nperm=1000, trace=TRUE)
plot(fit1, "income")
}

}
\references{
Berger, M., G. Tutz and M. Schmid (2019). Tree-Structured Modelling of Varying Coefficients. Statistics and Computing 29, 217-229,
https://doi.org/10.1007/s11222-018-9804-8.
}
\seealso{
\code{\link[TSVC]{TSVC}}, \code{\link[TSVC]{predict.TSVC}}, \code{\link[TSVC]{summary.TSVC}}
}
\author{
Moritz Berger <Moritz.Berger@imbie.uni-bonn.de> \cr \url{https://www.imbie.uni-bonn.de/people/dr-moritz-berger/}
}
