% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSSRattribution.R
\name{TSSRattribution}
\alias{TSSRattribution}
\title{Vegetation change attribution using the Time Series Segmentation of Residual Trends (MAIN FUNCTION)}
\usage{
TSSRattribution(
  CTSR.VI,
  CTSR.RF,
  CTSR.TM,
  max.acp,
  max.osp,
  C4frac = 0,
  sig = 0.05,
  season = "none",
  exclude = 0,
  allow.negative = FALSE,
  allowneg.retest = FALSE,
  h = 0.15,
  returnmodels = FALSE,
  AnnualRes = FALSE,
  SkipError = FALSE,
  retnonsig = TRUE,
  splitclim = TRUE,
  cliwindow = 20
)
}
\arguments{
\item{CTSR.VI}{Complete Monthly Time Series of Vegetation Index values.
An object of class \code{'ts'} object without NA's.}

\item{CTSR.RF}{Complete Time Series of Rainfall. An object of class 'ts' object without NA's
and be the same length and cover the same time range as CTSR.VI.
If ACP.table is provided, CTSR.RF will be automitaclly calculated using the
\code{\link{ACP.calculator}}}

\item{CTSR.TM}{Complete Time Series of temperature. An object of class 'ts' object without NA's
and be the same length and cover the same time range as CTSR.VI.  Default (CTSR.TM=NULL).
If ACT.table is provided, CTSR.RF will be automitaclly calculated using the
\code{\link{ACP.calculator}}}

\item{max.acp}{The max accumuation period. Must be an integer > 1.}

\item{max.osp}{The max offset period. Must be an integer >1}

\item{C4frac}{The fraction of vegetation that follows the C4 photosynthetic pathway, between 0 and 1}

\item{sig}{Significance of all the functions. defualt sig=0.05}

\item{season}{See \code{\link[bfast]{bfast}}. This season value only applies to bfast done using the CTS
VPR. if a non VPR adjusted BFAST is performed.a harmonic season is used.}

\item{exclude}{A numberic vector containg months excluded from breakpoint detection.  This was included to
allow sensor transitions to be masked.}

\item{allow.negative}{If true, will not preference positive slope in either CTSR or VI calculations. default=FALSE is set
because negative associations between rainfall and vegetation in water limited ecosystems is unexpected
If temperature data is included then this paramter is forced to TRUE.}

\item{allowneg.retest}{default=FALSE
If temperature data is provided but found to not be significant then a retest is performed.
This paramter is to allow negative on re-test.}

\item{h}{See \code{\link[bfast]{bfast}}, The.minimal segment size between potentially detected breaks in the trend model
given as fraction relative to the sample size (i.e. the minimal number of observations in each segment
divided by the total length of the timeseries. Default h = 0.15.}

\item{returnmodels}{Return all the created models as well as the original data}

\item{AnnualRes}{Report results in change per year. Defualt is False. Instead reports total change from the
start to the end of the time series.}

\item{SkipError}{Bool, If TRUE will handle most errors and return a dataframe filled with NA's.
Usefull when processing large datasets to stop analysis failing on a single pixel.
Use with caution. Defualt=FALSE.}

\item{retnonsig}{Bool. New in v0.3.0. Allows TSSRESTREND to return change estimates of values that filed the sig component in the residual analysis.
defualt FALSE will give the same result as eralier versions.}

\item{splitclim}{Bool, If TRUE Climate will be split into climate change and climate varibility as
per Burrell et al., (2020). If FALSE. will just return climate as per IPCC:
Chapter 3: Desertification in the IPCC Special Report on Climate Change, Desertification,
Land Degradation, Sustainable Land Management, Food Security, and Greenhouse gas fluxes in Terrestrial Ecosystems.
Defualt=True.}

\item{cliwindow}{The size of the window in years to be used for calculating climate change.}
}
\value{
\bold{tacp}
       The accumulation period for the annual max time series temperature
}
\description{
This is a wrapper function around the TSS-RESTREND main function that dows additional attribution.
It measues the Observed vegetation change, land use, climate change and climate varibility.
Unlike TSSRESTREND function, this requires both temperature and precitation data fo work.
}
\author{
Arden Burrell, aburrell@whrc.org
}
