% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMSE.r
\name{NMSE}
\alias{NMSE}
\title{NMSE error of prediction}
\usage{
NMSE(actual, prediction, train.actual)
}
\arguments{
\item{actual}{A vector or univariate time series containing actual values
for a time series that are to be compared against its respective
predictions.}

\item{prediction}{A vector or univariate time series containing time series
predictions that are to be compared against the values in \code{actual}.}

\item{train.actual}{A vector or univariate time series that was used to
train the model that produced the preditions in \code{prediction}.}
}
\value{
A numeric value of the NMSE error of prediction.
}
\description{
The function calculates the NMSE error between actual and predicted values.
}
\examples{

data(SantaFe.A,SantaFe.A.cont)
pred <- marimapred(SantaFe.A,n.ahead=100)
NMSE(SantaFe.A.cont[,1], pred, SantaFe.A[,1])

}
\references{
Z. Chen and Y. Yang, 2004, Assessing forecast accuracy measures,
Preprint Series, n. 2004-2010, p. 2004-10.
}
\seealso{
\code{\link{MSE}},\code{\link{MAPE}},\code{\link{sMAPE}},
\code{\link{MAXError}}
}
\author{
Rebecca Pontes Salles
}
\keyword{NMSE}
\keyword{error}
\keyword{prediction}
