% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregation.R
\name{plot_TSLA}
\alias{plot_TSLA}
\title{Plot aggregated structure}
\usage{
plot_TSLA(TSLA.object, X_2, X_2.org, lambda.index, alpha.index)
}
\arguments{
\item{TSLA.object}{A fit output from \code{TSLA.fit()},
or the \code{TSLA.fit} object in \code{cv.TSLA()}.}

\item{X_2}{Expanded design matrix in matrix form.}

\item{X_2.org}{Original design matrix in matrix form.}

\item{lambda.index}{Index of the \eqn{\lambda} value selected.}

\item{alpha.index}{Index of the \eqn{\alpha} value selected. The \eqn{\alpha} is
the tuning parameter for generalized lasso penalty.}
}
\value{
A plot
}
\description{
Return a tree plot.
}
\examples{
# Load the synthetic data
data(ClassificationExample)

tree.org <- ClassificationExample$tree.org   # original tree structure
x2.org <- ClassificationExample$x.org      # original design matrix
x1 <- ClassificationExample$x1
y <- ClassificationExample$y            # response

# Do the tree-guided expansion
expand.data <- getetmat(tree.org, x2.org)
x2 <- expand.data$x.expand              # expanded design matrix
tree.expand <- expand.data$tree.expand  # expanded tree structure

# Do train-test split
idtrain <- 1:200
x1.train <- as.matrix(x1[idtrain, ])
x2.train <- x2[idtrain, ]
y.train <- y[idtrain, ]
x1.test <- as.matrix(x1[-idtrain, ])
x2.test <- x2[-idtrain, ]
y.test <- y[-idtrain, ]

# specify some model parameters
set.seed(100)
control <- list(maxit = 100, mu = 1e-3, tol = 1e-5, verbose = FALSE)
modstr <- list(nlambda = 5,  alpha = seq(0, 1, length.out = 5))
simu.cv <- cv.TSLA(y = y.train, as.matrix(x1[idtrain, ]),
                   X_2 = x2.train,
                   treemat = tree.expand, family = 'logit',
                   penalty = 'CL2', pred.loss = 'AUC',
                   gamma.init = NULL, weight = c(1, 1), nfolds = 5,
                   group.weight = NULL, feature.weight = NULL,
                   control = control, modstr =  modstr)
plot_TSLA(simu.cv$TSLA.fit, x2, x2.org, simu.cv$lambda.min.index, simu.cv$alpha.min.index)



}
