% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_test.R
\name{z_cor_test}
\alias{z_cor_test}
\title{Test for Association/Correlation Between Paired Samples}
\usage{
z_cor_test(
  x,
  y,
  alternative = c("two.sided", "less", "greater", "equivalence", "minimal.effect"),
  method = c("pearson", "kendall", "spearman"),
  alpha = 0.05,
  null = 0
)
}
\arguments{
\item{x, y}{numeric vectors of data values. x and y must have the same length.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater", "less", "equivalence" (TOST), or "minimal.effect" (TOST). You can specify just the initial letter.}

\item{method}{a character string indicating which correlation coefficient is to be used for the test. One of "pearson", "kendall", or "spearman", can be abbreviated.}

\item{alpha}{alpha level (default = 0.05)}

\item{null}{a number indicating the null hypothesis. Default is a correlation of zero.}
}
\value{
A list with class "htest" containing the following components:
\describe{
  \item{\code{"p.value"}}{the p-value of the test.}
  \item{\code{"estimate"}}{the estimated measure of association, with name "pb", "wincor", "cor", "tau", or "rho" corresponding to the method employed.}
  \item{\code{"null.value"}}{the value of the association measure under the null hypothesis.}
  \item{\code{"alternative"}}{character string indicating the alternative hypothesis (the value of the input argument alternative). }
  \item{\code{"method"}}{a character string indicating how the association was measured.}
  \item{\code{"data.name"}}{a character string giving the names of the data.}
  \item{\code{"call"}}{the matched call.}
}
}
\description{
Test for association between paired samples, using one of Pearson's product moment correlation coefficient,Kendall's \eqn{\tau}{tau} or Spearman's \eqn{\rho}{rho}.
Unlike the stats version of cor.test, this function allows users to set the null to a value other than zero.
}
\details{
This function uses Fisher's z transformation for the correlations, but uses Fieller's correction of the standard error for Spearman's rho and Kendall's tau.
}
\examples{
# example code
x <- c(44.4, 45.9, 41.9, 53.3, 44.7, 44.1, 50.7, 45.2, 60.1)
y <- c( 2.6,  3.1,  2.5,  5.0,  3.6,  4.0,  5.2,  2.8,  3.8)
# Sig test
z_cor_test(x, y, method = "kendall", alternative = "t", null = 0)
# MET test
z_cor_test(x, y, method = "kendall", alternative = "min", null = .2)
}
\references{
Goertzen, J. R., & Cribbie, R. A. (2010). Detecting a lack of association: An equivalence testing approach. British Journal of Mathematical and Statistical Psychology, 63(3), 527-537. https://doi.org/10.1348/000711009X475853, formula page 531.
}
