% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datatostone.h.R
\name{dataTOSTone}
\alias{dataTOSTone}
\title{TOST One Sample T-Test}
\usage{
dataTOSTone(data, vars, mu = 0, low_eqbound_d = -0.5,
  high_eqbound_d = 0.5, alpha = 0.05, desc = FALSE, plots = FALSE)
}
\arguments{
\item{data}{the data as a data frame}

\item{vars}{a vector of strings naming variables of interest in \code{data}}

\item{mu}{a number (default: 0) to compare against}

\item{low_eqbound_d}{lower equivalence bounds (e.g., -0.5) expressed in 
standardized mean difference (Cohen's d)}

\item{high_eqbound_d}{upper equivalence bounds (e.g., 0.5) expressed in 
standardized mean difference (Cohen's d)}

\item{alpha}{alpha level (default = 0.05)}

\item{desc}{\code{TRUE} or \code{FALSE} (default), provide descriptive 
statistics}

\item{plots}{\code{TRUE} or \code{FALSE} (default), provide plots}
}
\description{
TOST One Sample T-Test
}
\examples{
library("TOSTER")

dataTOSTone(data = iris, vars = "Sepal.Width", mu = 3, low_eqbound_d = -0.3, high_eqbound_d = 0.3,
            alpha = 0.05, desc = TRUE, plots = TRUE)

TOSTone(m=3.05733,mu=3,sd=0.4358663,n=150,low_eqbound_d=-0.3, high_eqbound_d=0.3, alpha=0.05)

}
