% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localTest_CTP.R
\name{localTest_CTP}
\alias{localTest_CTP}
\title{A Closed Testing Procedure for any local test satisfying the conditions of Mogensen and Markussen (2021) using an O(n^2) shortcut.}
\usage{
localTest_CTP(localTest, pvals, alpha = 0.05, ...)
}
\arguments{
\item{localTest}{A function which defines the choice of local test to use.}

\item{pvals}{A vector of p-values}

\item{alpha}{Level to perform each intersection test at. Defaults to 0.05}

\item{...}{Additional arguments}
}
\value{
A data.frame containing:
* p_adjust: The CTP adjusted p-value, controlling the FWER strongly.
* Index: The original index of the unsorted p-value inputs.
}
\description{
A Closed Testing Procedure for any local test satisfying the conditions of Mogensen and Markussen (2021) using an O(n^2) shortcut.
}
\examples{
## Simulate some p-values
## The first 10 are from false hypotheses, the next 10 are from true
pvals <- c (
  rbeta(10, 1, 20),  ## Mean value of .05
  runif(10)
)
## Perform the CTP using a local Bonferroni test
localTest_CTP(function(x) {min(c(length(x) * min(x), 1))}, pvals)
}
