% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestSet_localTest.R
\name{TestSet_localTest}
\alias{TestSet_localTest}
\title{Test a subset of hypotheses in its closure using a user-specified local test}
\usage{
TestSet_localTest(
  localTest,
  pvals,
  subset,
  alpha = 0.05,
  earlyStop = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{localTest}{Function which defines a combination test.}

\item{pvals}{Numeric vector of p-values}

\item{subset}{Numeric vector; the subset to be tested}

\item{alpha}{Numeric; the level to test at, if stopping early. Defaults
to 0.05}

\item{earlyStop}{Logical; set to TRUE to stop as soon as a hypothesis can be
accepted at level alpha. This speeds up the procedure, but now only provides
lower bounds on the p-values for the global test.}

\item{verbose}{Logical; set to TRUE to print progress.}

\item{...}{Additional arguments to be passed onto TMTI()}
}
\value{
The adjusted p-value for the test of the hypothesis that there are
no false hypotheses among the selected subset.
}
\description{
Test a subset of hypotheses in its closure using a user-specified local test
}
\examples{
## Simulate p-values; 10 from false hypotheses, 10 from true
pvals <- sort(c (
    rbeta(10, 1, 20),  # Mean value of .1
    runif(10)
))
## Test whether the highest 10 contain any false hypotheses using a Bonferroni test
TestSet_localTest(function(x) {min(c(1, length(x) * min(x)))}, pvals, subset = 11:20)
}
